/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};

/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {

/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;

/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};

/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);

/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;

/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}


/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;

/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;

/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";

/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	/**
	 * Copyright (C) 2014-2017 ServMask Inc.
	 *
	 * This program is free software: you can redistribute it and/or modify
	 * it under the terms of the GNU General Public License as published by
	 * the Free Software Foundation, either version 3 of the License, or
	 * (at your option) any later version.
	 *
	 * This program is distributed in the hope that it will be useful,
	 * but WITHOUT ANY WARRANTY; without even the implied warranty of
	 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 * GNU General Public License for more details.
	 *
	 * You should have received a copy of the GNU General Public License
	 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
	 *
	 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
	 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
	 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
	 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
	 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
	 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
	 */

	var Report = __webpack_require__(1),
	    Feedback = __webpack_require__(2),
	    Util = __webpack_require__(3),
	    Import = __webpack_require__(4);

	jQuery(document).ready(function ($) {
		'use strict';

		$('.ai1wm-backup-actions > a').hover(function () {
			$(this).addClass('ai1wm-button-on');
		}, function () {
			$(this).removeClass('ai1wm-button-on');
		});

		// Delete file
		$('.ai1wm-backup-delete').click(function (e) {
			var self = $(this);

			// Delete file
			if (confirm('Are you sure you want to delete this file?')) {
				$.ajax({
					type: 'POST',
					url: ai1wm_backups.ajax.url,
					data: { 'archive': self.data('archive') },
					success: function success(result) {
						var errors = result.errors;
						if (errors.length === 0) {
							self.closest('tr').remove();
							if ($('.ai1wm-backups tbody tr').length === 0) {
								$('.ai1wm-backups').addClass('ai1wm-hide');
								$('.ai1wm-backups-empty').removeClass('ai1wm-hide');
							}
						}
					},
					dataType: 'json'
				});
			}

			e.preventDefault();
		});

		var model = new Import();

		// Restore from file
		$('.ai1wm-backup-restore').click(function (e) {
			var storage = Util.random(12);
			var options = Util.form('#ai1wm-backups-form').concat({ name: 'storage', value: storage }).concat({ name: 'archive', value: $(this).data('archive') });

			// Set global params
			model.setParams(options);

			// Start import
			model.start();

			e.preventDefault();
		});
	});

/***/ },
/* 1 */
/***/ function(module, exports) {

	'use strict';

	/**
	 * Copyright (C) 2014-2017 ServMask Inc.
	 *
	 * This program is free software: you can redistribute it and/or modify
	 * it under the terms of the GNU General Public License as published by
	 * the Free Software Foundation, either version 3 of the License, or
	 * (at your option) any later version.
	 *
	 * This program is distributed in the hope that it will be useful,
	 * but WITHOUT ANY WARRANTY; without even the implied warranty of
	 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 * GNU General Public License for more details.
	 *
	 * You should have received a copy of the GNU General Public License
	 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
	 *
	 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
	 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
	 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
	 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
	 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
	 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
	 */

	jQuery(document).ready(function ($) {
		'use strict';

		$('#ai1wm-report-problem-button').click(function (e) {
			$(this).next('.ai1wm-report-problem-dialog').toggleClass('ai1wm-report-active');

			e.preventDefault();
		});

		$('#ai1wm-report-cancel').click(function (e) {
			$(this).closest('.ai1wm-report-problem-dialog').removeClass('ai1wm-report-active');

			e.preventDefault();
		});

		$('#ai1wm-report-submit').click(function () {
			var email = $('.ai1wm-report-email').val();
			var message = $('.ai1wm-report-message').val();
			var terms = $('.ai1wm-report-terms').is(':checked');

			$.ajax({
				type: 'POST',
				url: ai1wm_report.ajax.url,
				data: { 'ai1wm_email': email, 'ai1wm_message': message, 'ai1wm_terms': +terms },
				success: function success(data) {
					var errors = data.errors;
					if (errors.length > 0) {
						// Reset previous messages
						$('.ai1wm-report-problem-dialog .ai1wm-message').remove();

						var content = $('<div />').addClass('ai1wm-message ai1wm-error-message');
						$.each(errors, function (key, value) {
							content.append('<p>' + value + '</p>');
						});

						$('.ai1wm-report-problem-dialog').prepend(content);
					} else {
						var _content = $('<div />').addClass('ai1wm-message ai1wm-success-message').append('<p>Thanks for submitting your request!</p>');
						$('.ai1wm-report-problem-dialog').html(_content);

						// Hide message
						setTimeout(function () {
							$('.ai1wm-report-problem-dialog').removeClass('ai1wm-report-active');
						}, 2000);
					}
				},
				dataType: 'json',
				async: false
			});
		});
	});

/***/ },
/* 2 */
/***/ function(module, exports) {

	'use strict';

	/**
	 * Copyright (C) 2014-2017 ServMask Inc.
	 *
	 * This program is free software: you can redistribute it and/or modify
	 * it under the terms of the GNU General Public License as published by
	 * the Free Software Foundation, either version 3 of the License, or
	 * (at your option) any later version.
	 *
	 * This program is distributed in the hope that it will be useful,
	 * but WITHOUT ANY WARRANTY; without even the implied warranty of
	 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 * GNU General Public License for more details.
	 *
	 * You should have received a copy of the GNU General Public License
	 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
	 *
	 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
	 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
	 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
	 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
	 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
	 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
	 */

	jQuery(document).ready(function ($) {
		'use strict';

		// Reset feedback form

		$('.ai1wm-feedback-type').attr('checked', false);

		// Review
		$('#ai1wm-feedback-type-link-1').click(function (e) {
			var radio = $('#ai1wm-feedback-type-1');
			if (radio.is(':checked')) {
				radio.attr('checked', false);
				e.preventDefault();
			} else {
				radio.attr('checked', true);
			}
		});

		// Improvement
		$('#ai1wm-feedback-type-2').click(function () {
			// Hide other options
			$('#ai1wm-feedback-type-1, #ai1wm-feedback-type-3').closest('li').hide();

			// change placeholder message
			$('.ai1wm-feedback-form').find('.ai1wm-feedback-message').attr('placeholder', 'Leave plugin developers any feedback here');

			// Show feedback form
			$('.ai1wm-feedback-form').fadeIn();
		});

		// Help
		$('#ai1wm-feedback-type-3').click(function () {
			// Hide other options
			$('#ai1wm-feedback-type-1, #ai1wm-feedback-type-2').closest('li').hide();

			// change placeholder message
			$('.ai1wm-feedback-form').find('.ai1wm-feedback-message').attr('placeholder', 'How may we help you?');

			// Show feedback form
			$('.ai1wm-feedback-form').fadeIn();
		});

		// Cancel feedback form
		$('#ai1wm-feedback-cancel').click(function (e) {
			$('.ai1wm-feedback-form').fadeOut(function () {
				$('.ai1wm-feedback-type').attr('checked', false).closest('li').show();
			});
			e.preventDefault();
		});

		// Send feedback form
		$('#ai1wm-feedback-submit').click(function () {
			var type = $('.ai1wm-feedback-type:checked').val();
			var email = $('.ai1wm-feedback-email').val();
			var message = $('.ai1wm-feedback-message').val();
			var terms = $('.ai1wm-feedback-terms').is(':checked');

			$.ajax({
				type: 'POST',
				url: ai1wm_feedback.ajax.url,
				data: { 'ai1wm_type': type, 'ai1wm_email': email, 'ai1wm_message': message, 'ai1wm_terms': +terms },
				success: function success(data) {
					var errors = data.errors;
					if (errors.length > 0) {
						// Reset previous messages
						$('.ai1wm-feedback .ai1wm-message').remove();

						var content = $('<div />').addClass('ai1wm-message ai1wm-error-message');
						$.each(errors, function (key, value) {
							content.append('<p>' + value + '</p>');
						});

						$('.ai1wm-feedback').prepend(content);
					} else {
						var _content = $('<div />').addClass('ai1wm-message ai1wm-success-message').append('<p>Thanks for submitting your feedback!</p>');
						$('.ai1wm-feedback').html(_content);
					}
				},
				dataType: 'json',
				async: false
			});
		});
	});

/***/ },
/* 3 */
/***/ function(module, exports) {

	'use strict';

	/**
	 * Copyright (C) 2014-2017 ServMask Inc.
	 *
	 * This program is free software: you can redistribute it and/or modify
	 * it under the terms of the GNU General Public License as published by
	 * the Free Software Foundation, either version 3 of the License, or
	 * (at your option) any later version.
	 *
	 * This program is distributed in the hope that it will be useful,
	 * but WITHOUT ANY WARRANTY; without even the implied warranty of
	 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 * GNU General Public License for more details.
	 *
	 * You should have received a copy of the GNU General Public License
	 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
	 *
	 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
	 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
	 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
	 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
	 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
	 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
	 */

	var $ = jQuery;

	module.exports = {
		random: function random(len) {
			var text = '';
			var possible = 'abcdefghijklmnopqrstuvwxyz0123456789';

			for (var i = 0; i < len; i++) {
				text += possible.charAt(Math.floor(Math.random() * possible.length));
			}

			return text;
		},
		form: function form(id) {
			return $(id).serializeArray();
		},
		ucfirst: function ucfirst(text) {
			return text.charAt(0).toUpperCase() + text.slice(1);
		},
		list: function list(input) {
			// Convert object to list
			if ($.isPlainObject(input)) {
				var result = [];
				var params = decodeURIComponent($.param(input)).split('&');

				// Loop over params
				$.each(params, function (index, item) {
					var value = item.split('=');

					// Add item
					result.push({ name: value[0], value: value[1] });
				});

				return result;
			}

			return input;
		}
	};

/***/ },
/* 4 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	/**
	 * Copyright (C) 2014-2017 ServMask Inc.
	 *
	 * This program is free software: you can redistribute it and/or modify
	 * it under the terms of the GNU General Public License as published by
	 * the Free Software Foundation, either version 3 of the License, or
	 * (at your option) any later version.
	 *
	 * This program is distributed in the hope that it will be useful,
	 * but WITHOUT ANY WARRANTY; without even the implied warranty of
	 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 * GNU General Public License for more details.
	 *
	 * You should have received a copy of the GNU General Public License
	 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
	 *
	 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
	 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
	 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
	 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
	 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
	 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
	 */

	var Util = __webpack_require__(3),
	    Modal = __webpack_require__(5),
	    $ = jQuery;

	var Import = function Import() {
		var self = this;

		// Set params
		this.params = [];

		// Set stop flag
		this.stopImport = false;

		// Set modal
		this.modal = new Modal();

		// Set confirm listener
		this.modal.onConfirm = function (options) {
			self.onConfirm(options);
		};

		// Set blogs listener
		this.modal.onBlogs = function (options) {
			self.onBlogs(options);
		};

		// Set stop listener
		this.modal.onStop = function (options) {
			self.onStop(options);
		};
	};

	Import.prototype.setParams = function (params) {
		this.params = Util.list(params);
	};

	Import.prototype.start = function (options, retries) {
		var self = this;
		var retries = retries || 0;

		// Set stop flag
		if (retries === 0) {
			this.stopImport = false;
		}

		// Stop running import
		if (this.stopImport) {
			return;
		}

		// Initializing beforeunload event
		$(window).bind('beforeunload', function () {
			return 'You are about to stop importing your website, are you sure?';
		});

		// Set initial status
		this.setStatus({ type: 'info', message: 'Preparing to import...' });

		// Set params
		var params = this.params.concat({ name: 'secret_key', value: ai1wm_import.secret_key });

		// Set additional params
		if (options) {
			params = params.concat(Util.list(options));
		}

		// Import
		$.post(ai1wm_import.ajax.url, params, null, 'json').done(function () {
			self.getStatus();
		}).done(function (params) {
			if (params) {
				self.run(params);
			}
		}).fail(function () {
			var timeout = retries * 1000;
			if (retries >= 5) {
				return self.setStatus({
					type: 'error',
					message: 'Unable to start the import. Refresh the page and try again'
				});
			}

			retries++;

			setTimeout(self.start.bind(self, options, retries), timeout);
		});
	};

	Import.prototype.run = function (params, retries) {
		var self = this;
		var retries = retries || 0;

		// Stop running import
		if (this.stopImport) {
			return;
		}

		// Import
		$.post(ai1wm_import.ajax.url, params, null, 'json').done(function (params) {
			if (params) {
				self.run(params);
			}
		}).fail(function () {
			var timeout = retries * 1000;

			retries++;

			setTimeout(self.run.bind(self, params, retries), timeout);
		});
	};

	Import.prototype.confirm = function (options, retries) {
		var self = this;
		var retries = retries || 0;

		// Stop running import
		if (this.stopImport) {
			return;
		}

		// Set params
		var params = this.params.concat({ name: 'secret_key', value: ai1wm_import.secret_key }).concat({ name: 'priority', value: 150 });

		// Set additional params
		if (options) {
			params = params.concat(Util.list(options));
		}

		// Confirm
		$.post(ai1wm_import.ajax.url, params, null, 'json').done(function () {
			self.getStatus();
		}).done(function (params) {
			if (params) {
				self.run(params);
			}
		}).fail(function () {
			var timeout = retries * 1000;
			if (retries >= 5) {
				return self.setStatus({
					type: 'error',
					message: 'Unable to confirm the import. Refresh the page and try again'
				});
			}

			retries++;

			setTimeout(self.confirm.bind(self, options, retries), timeout);
		});
	};

	Import.prototype.blogs = function (options, retries) {
		var self = this;
		var retries = retries || 0;

		// Stop running import
		if (this.stopImport) {
			return;
		}

		// Set params
		var params = this.params.concat({ name: 'secret_key', value: ai1wm_import.secret_key }).concat({ name: 'priority', value: 150 });

		// Set additional params
		if (options) {
			params = params.concat(Util.list(options));
		}

		// Blogs
		$.post(ai1wm_import.ajax.url, params, null, 'json').done(function () {
			self.getStatus();
		}).done(function (params) {
			if (params) {
				self.run(params);
			}
		}).fail(function () {
			var timeout = retries * 1000;
			if (retries >= 5) {
				return self.setStatus({
					type: 'error',
					message: 'Unable to prepare blogs the import. Refresh the page and try again'
				});
			}

			retries++;

			setTimeout(self.blogs.bind(self, options, retries), timeout);
		});
	};

	Import.prototype.clean = function (options, retries) {
		var self = this;
		var retries = retries || 0;

		// Set stop flag
		this.stopImport = true;

		// Set initial status
		this.setStatus({ type: 'info', message: 'Please wait, stopping the import...' });

		// Set params
		var params = this.params.concat({ name: 'secret_key', value: ai1wm_import.secret_key }).concat({ name: 'priority', value: 400 });

		// Set additional params
		if (options) {
			params = params.concat(Util.list(options));
		}

		// Clean
		$.post(ai1wm_import.ajax.url, params, null, 'json').done(function () {
			// Unbinding the beforeunload event when we stop importing
			$(window).unbind('beforeunload');

			// Destroy modal
			self.modal.destroy();
		}).fail(function () {
			var timeout = retries * 1000;
			if (retries >= 5) {
				return self.setStatus({
					type: 'error',
					message: 'Unable to stop the import. Refresh the page and try again'
				});
			}

			retries++;

			setTimeout(self.clean.bind(self, options, retries), timeout);
		});
	};

	Import.prototype.getStatus = function () {
		var self = this;

		// Stop getting status
		if (this.stopImport) {
			return;
		}

		$.ajax({
			cache: false,
			url: ai1wm_import.status.url,
			dataType: 'json'
		}).done(function (params) {
			if (params) {
				self.setStatus(params);

				// Next status
				switch (params.type) {
					case 'done':
					case 'error':
						// Unbinding the beforeunload event when any case is performed
						$(window).unbind('beforeunload');
						return;

					case 'confirm':
					case 'blogs':
						return;
				}
			}

			// Import is not done yet, let's check status in 3 seconds
			setTimeout(self.getStatus.bind(self), 3000);
		}).fail(function () {
			// Import is not done yet, let's check status in 3 seconds
			setTimeout(self.getStatus.bind(self), 3000);
		});;
	};

	Import.prototype.setStatus = function (params) {
		this.modal.render(params);
	};

	Import.prototype.onConfirm = function (options) {
		this.confirm(options);
	};

	Import.prototype.onBlogs = function (options) {
		this.blogs(options);
	};

	Import.prototype.onStop = function (options) {
		this.clean(options);
	};

	module.exports = Import;

/***/ },
/* 5 */
/***/ function(module, exports) {

	'use strict';

	/**
	 * Copyright (C) 2014-2017 ServMask Inc.
	 *
	 * This program is free software: you can redistribute it and/or modify
	 * it under the terms of the GNU General Public License as published by
	 * the Free Software Foundation, either version 3 of the License, or
	 * (at your option) any later version.
	 *
	 * This program is distributed in the hope that it will be useful,
	 * but WITHOUT ANY WARRANTY; without even the implied warranty of
	 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 * GNU General Public License for more details.
	 *
	 * You should have received a copy of the GNU General Public License
	 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
	 *
	 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
	 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
	 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
	 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
	 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
	 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
	 */

	var $ = jQuery;

	var Modal = function Modal() {
		var self = this;
		this.view = null;

		// Error Modal
		this.error = function (params) {

			// Create the modal container
			var container = $('<div></div>');

			// Create section to hold title, message and action
			var section = $('<section></section>');

			// Create header to hold title
			var header = $('<h1></h1>');

			// Create paragraph to hold mesage
			var message = $('<p></p>').html(params.message);

			// Create action section
			var action = $('<div></div>');

			// Create title
			var title = $('<span></span>').addClass('ai1wm-title-red').text('Unable to import');

			// Create close button
			var closeButton = $('<button type="button" class="ai1wm-button-red">Close</button>').on('click', function () {
				self.destroy();
			});

			// Append close button
			action.append(closeButton);

			// Append title to section
			header.append(title);

			// Append header and message to section
			section.append(header).append(message);

			// Append section and action to container
			container.append(section).append(action);

			// Render modal
			self.modal.html(container).show();
			self.overlay.show();
		};

		// Progress Modal
		this.progress = function (params) {
			if (this.view === 'progress') {

				// Update progressBarMeter
				this.progress.progressBarMeter.width(params.percent + '%');

				// Update progressBarPercent
				this.progress.progressBarPercent.text(params.percent + '%');
			} else {

				// Create the modal container
				var container = $('<div></div>');

				// Create section to hold title, message and action
				var section = $('<section></section>');

				// Create header to hold progress bar
				var header = $('<h1></h1>');

				// Create paragraph to hold mesage
				var message = $('<p></p>');

				// Create action section
				var action = $('<div></div>');

				// Create progressBar
				var progressBar = $('<span class="ai1wm-progress-bar"></span>');

				// Create progressBarMeter
				this.progress.progressBarMeter = $('<span class="ai1wm-progress-bar-meter"></span>').width(params.percent + '%');

				// Create progressBarPercent
				this.progress.progressBarPercent = $('<span class="ai1wm-progress-bar-percent">0%</span>').text(params.percent + '%');

				// Create stop import
				var stopButton = $('<button type="button" class="ai1wm-button-red"><i class="ai1wm-icon-notification"></i> Stop import</button>').on('click', function () {
					$(this).attr('disabled', 'disabled');
					self.onStop();
				});

				// Append progress meter and progress percent
				progressBar.append(this.progress.progressBarMeter).append(this.progress.progressBarPercent);

				// Append stop button
				action.append(stopButton);

				// Append progress bar to section
				header.append(progressBar);

				// Append header to section
				section.append(header);

				// Append section and action to container
				container.append(section).append(action);

				// Render modal
				self.modal.html(container).show();
				self.overlay.show();
			}
		};

		// Confirm Modal
		this.confirm = function (params) {

			// Create the modal container
			var container = $('<div></div>');

			// Create section to hold title, message and action
			var section = $('<section></section>');

			// Create header to hold warning
			var header = $('<h1></h1>');

			// Create paragraph to hold mesage
			var message = $('<p></p>').html(params.message);

			// Create action section
			var action = $('<div></div>');

			// Create warning
			var warning = $('<span class="ai1wm-icon-notification"></span>');

			// Create confirm button
			var confirmButton = $('<button type="button" class="ai1wm-button-green">Continue</button>').on('click', function () {
				$(this).attr('disabled', 'disabled');
				self.onConfirm();
			});

			// Append confirm button
			action.append(confirmButton);

			// Append warning to section
			header.append(warning);

			// Append header and message to section
			section.append(header).append(message);

			// Append section and action to container
			container.append(section).append(action);

			// Render modal
			self.modal.html(container).show();
			self.overlay.show();
		};

		// Blogs Modal
		this.blogs = function (params) {

			// Create the modal container
			var container = $('<form></form>');

			// Create section to hold title, message and action
			var section = $('<section></section>');

			// Create header to hold title
			var header = $('<h1></h1>');

			// Create paragraph to hold mesage
			var message = $('<p></p>').html(params.message);

			// Create action section
			var action = $('<div></div>');

			// Create title
			var title = $('<span></span>').addClass('ai1wm-title-grey').text(params.title);

			// Create continue button
			var continueButton = $('<button type="button" class="ai1wm-button-green">Continue</button>').on('click', function () {
				$(this).attr('disabled', 'disabled');
				self.onBlogs($(this).closest('form').serializeArray());
			});

			// Append continue button
			action.append(continueButton);

			// Append title to section
			header.append(title);

			// Append header and message to section
			section.append(header).append(message);

			// Append section and action to container
			container.append(section).append(action);

			// Render modal
			self.modal.html(container).show();
			self.overlay.show();
		};

		// Info Modal
		this.info = function (params) {

			// Create the modal container
			var container = $('<div></div>');

			// Create section to hold title, message and action
			var section = $('<section></section>');

			// Create header to hold loader
			var header = $('<h1></h1>');

			// Create paragraph to hold mesage
			var message = $('<p></p>').html(params.message);

			// Create action section
			var action = $('<div></div>');

			// Create loader
			var loader = $('<span class="ai1wm-loader"></span>');

			// Create stop import
			var stopButton = $('<button type="button" class="ai1wm-button-red"><i class="ai1wm-icon-notification"></i> Stop import</button>').attr('disabled', 'disabled');

			// Append stop button
			action.append(stopButton);

			// Append loader to header
			header.append(loader);

			// Append header and message to section
			section.append(header).append(message);

			// Append section and action to container
			container.append(section).append(action);

			// Render modal
			self.modal.html(container).show();
			self.overlay.show();
		};

		// Done Modal
		this.done = function (params) {

			// Create the modal container
			var container = $('<div></div>');

			// Create section to hold title, message and action
			var section = $('<section></section>');

			// Create header to hold title
			var header = $('<h1></h1>');

			// Create paragraph to hold mesage
			var message = $('<p></p>').html(params.message);

			// Create action section
			var action = $('<div></div>');

			// Create title
			var title = $('<span></span>').addClass('ai1wm-title-green').text(params.title);

			// Create close button
			var closeButton = $('<button type="button" class="ai1wm-button-red">Close</button>').on('click', function () {
				self.destroy();
			});

			// Append close button
			action.append(closeButton);

			// Append title to section
			header.append(title);

			// Append header and message to section
			section.append(header).append(message);

			// Append section and action to container
			container.append(section).append(action);

			// Render modal
			self.modal.html(container).show();
			self.overlay.show();
		};

		// Create the overlay
		this.overlay = $('<div class="ai1wm-overlay"></div>');

		// Create the modal container
		this.modal = $('<div class="ai1wm-modal-container"></div>');

		$('body').append(this.overlay) // Append overlay to body
		.append(this.modal); // Append modal to body
	};

	Modal.prototype.render = function (params) {

		// Show modal
		switch (params.type) {
			case 'error':
				this.error(params);
				break;

			case 'confirm':
				this.confirm(params);
				break;

			case 'blogs':
				this.blogs(params);
				break;

			case 'progress':
				this.progress(params);
				break;

			case 'info':
				this.info(params);
				break;

			case 'done':
				this.done(params);
				break;
		}

		this.view = params.type;
	};

	Modal.prototype.destroy = function () {
		this.modal.hide();
		this.overlay.hide();
	};

	module.exports = Modal;

/***/ }
/******/ ]);