/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};

/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {

/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;

/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};

/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);

/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;

/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}


/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;

/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;

/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";

/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	/**
	 * Copyright (C) 2014-2017 ServMask Inc.
	 *
	 * This program is free software: you can redistribute it and/or modify
	 * it under the terms of the GNU General Public License as published by
	 * the Free Software Foundation, either version 3 of the License, or
	 * (at your option) any later version.
	 *
	 * This program is distributed in the hope that it will be useful,
	 * but WITHOUT ANY WARRANTY; without even the implied warranty of
	 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 * GNU General Public License for more details.
	 *
	 * You should have received a copy of the GNU General Public License
	 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
	 *
	 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
	 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
	 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
	 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
	 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
	 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
	 */

	var Report = __webpack_require__(1),
	    Feedback = __webpack_require__(2),
	    Deprecated = __webpack_require__(8),
	    FileUploader = __webpack_require__(12);

	jQuery(document).ready(function ($) {
	  'use strict';

	  var uploader = new FileUploader();
	  uploader.init();

	  // Expands/Collapses Import from
	  $('.ai1wm-expandable > div.ai1wm-button-main').on('click', function () {
	    $(this).parent().toggleClass('ai1wm-open');
	  });
	});

/***/ },
/* 1 */
/***/ function(module, exports) {

	'use strict';

	/**
	 * Copyright (C) 2014-2017 ServMask Inc.
	 *
	 * This program is free software: you can redistribute it and/or modify
	 * it under the terms of the GNU General Public License as published by
	 * the Free Software Foundation, either version 3 of the License, or
	 * (at your option) any later version.
	 *
	 * This program is distributed in the hope that it will be useful,
	 * but WITHOUT ANY WARRANTY; without even the implied warranty of
	 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 * GNU General Public License for more details.
	 *
	 * You should have received a copy of the GNU General Public License
	 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
	 *
	 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
	 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
	 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
	 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
	 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
	 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
	 */

	jQuery(document).ready(function ($) {
		'use strict';

		$('#ai1wm-report-problem-button').click(function (e) {
			$(this).next('.ai1wm-report-problem-dialog').toggleClass('ai1wm-report-active');

			e.preventDefault();
		});

		$('#ai1wm-report-cancel').click(function (e) {
			$(this).closest('.ai1wm-report-problem-dialog').removeClass('ai1wm-report-active');

			e.preventDefault();
		});

		$('#ai1wm-report-submit').click(function () {
			var email = $('.ai1wm-report-email').val();
			var message = $('.ai1wm-report-message').val();
			var terms = $('.ai1wm-report-terms').is(':checked');

			$.ajax({
				type: 'POST',
				url: ai1wm_report.ajax.url,
				data: { 'ai1wm_email': email, 'ai1wm_message': message, 'ai1wm_terms': +terms },
				success: function success(data) {
					var errors = data.errors;
					if (errors.length > 0) {
						// Reset previous messages
						$('.ai1wm-report-problem-dialog .ai1wm-message').remove();

						var content = $('<div />').addClass('ai1wm-message ai1wm-error-message');
						$.each(errors, function (key, value) {
							content.append('<p>' + value + '</p>');
						});

						$('.ai1wm-report-problem-dialog').prepend(content);
					} else {
						var _content = $('<div />').addClass('ai1wm-message ai1wm-success-message').append('<p>Thanks for submitting your request!</p>');
						$('.ai1wm-report-problem-dialog').html(_content);

						// Hide message
						setTimeout(function () {
							$('.ai1wm-report-problem-dialog').removeClass('ai1wm-report-active');
						}, 2000);
					}
				},
				dataType: 'json',
				async: false
			});
		});
	});

/***/ },
/* 2 */
/***/ function(module, exports) {

	'use strict';

	/**
	 * Copyright (C) 2014-2017 ServMask Inc.
	 *
	 * This program is free software: you can redistribute it and/or modify
	 * it under the terms of the GNU General Public License as published by
	 * the Free Software Foundation, either version 3 of the License, or
	 * (at your option) any later version.
	 *
	 * This program is distributed in the hope that it will be useful,
	 * but WITHOUT ANY WARRANTY; without even the implied warranty of
	 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 * GNU General Public License for more details.
	 *
	 * You should have received a copy of the GNU General Public License
	 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
	 *
	 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
	 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
	 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
	 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
	 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
	 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
	 */

	jQuery(document).ready(function ($) {
		'use strict';

		// Reset feedback form

		$('.ai1wm-feedback-type').attr('checked', false);

		// Review
		$('#ai1wm-feedback-type-link-1').click(function (e) {
			var radio = $('#ai1wm-feedback-type-1');
			if (radio.is(':checked')) {
				radio.attr('checked', false);
				e.preventDefault();
			} else {
				radio.attr('checked', true);
			}
		});

		// Improvement
		$('#ai1wm-feedback-type-2').click(function () {
			// Hide other options
			$('#ai1wm-feedback-type-1, #ai1wm-feedback-type-3').closest('li').hide();

			// change placeholder message
			$('.ai1wm-feedback-form').find('.ai1wm-feedback-message').attr('placeholder', 'Leave plugin developers any feedback here');

			// Show feedback form
			$('.ai1wm-feedback-form').fadeIn();
		});

		// Help
		$('#ai1wm-feedback-type-3').click(function () {
			// Hide other options
			$('#ai1wm-feedback-type-1, #ai1wm-feedback-type-2').closest('li').hide();

			// change placeholder message
			$('.ai1wm-feedback-form').find('.ai1wm-feedback-message').attr('placeholder', 'How may we help you?');

			// Show feedback form
			$('.ai1wm-feedback-form').fadeIn();
		});

		// Cancel feedback form
		$('#ai1wm-feedback-cancel').click(function (e) {
			$('.ai1wm-feedback-form').fadeOut(function () {
				$('.ai1wm-feedback-type').attr('checked', false).closest('li').show();
			});
			e.preventDefault();
		});

		// Send feedback form
		$('#ai1wm-feedback-submit').click(function () {
			var type = $('.ai1wm-feedback-type:checked').val();
			var email = $('.ai1wm-feedback-email').val();
			var message = $('.ai1wm-feedback-message').val();
			var terms = $('.ai1wm-feedback-terms').is(':checked');

			$.ajax({
				type: 'POST',
				url: ai1wm_feedback.ajax.url,
				data: { 'ai1wm_type': type, 'ai1wm_email': email, 'ai1wm_message': message, 'ai1wm_terms': +terms },
				success: function success(data) {
					var errors = data.errors;
					if (errors.length > 0) {
						// Reset previous messages
						$('.ai1wm-feedback .ai1wm-message').remove();

						var content = $('<div />').addClass('ai1wm-message ai1wm-error-message');
						$.each(errors, function (key, value) {
							content.append('<p>' + value + '</p>');
						});

						$('.ai1wm-feedback').prepend(content);
					} else {
						var _content = $('<div />').addClass('ai1wm-message ai1wm-success-message').append('<p>Thanks for submitting your feedback!</p>');
						$('.ai1wm-feedback').html(_content);
					}
				},
				dataType: 'json',
				async: false
			});
		});
	});

/***/ },
/* 3 */
/***/ function(module, exports) {

	'use strict';

	/**
	 * Copyright (C) 2014-2017 ServMask Inc.
	 *
	 * This program is free software: you can redistribute it and/or modify
	 * it under the terms of the GNU General Public License as published by
	 * the Free Software Foundation, either version 3 of the License, or
	 * (at your option) any later version.
	 *
	 * This program is distributed in the hope that it will be useful,
	 * but WITHOUT ANY WARRANTY; without even the implied warranty of
	 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 * GNU General Public License for more details.
	 *
	 * You should have received a copy of the GNU General Public License
	 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
	 *
	 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
	 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
	 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
	 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
	 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
	 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
	 */

	var $ = jQuery;

	module.exports = {
		random: function random(len) {
			var text = '';
			var possible = 'abcdefghijklmnopqrstuvwxyz0123456789';

			for (var i = 0; i < len; i++) {
				text += possible.charAt(Math.floor(Math.random() * possible.length));
			}

			return text;
		},
		form: function form(id) {
			return $(id).serializeArray();
		},
		ucfirst: function ucfirst(text) {
			return text.charAt(0).toUpperCase() + text.slice(1);
		},
		list: function list(input) {
			// Convert object to list
			if ($.isPlainObject(input)) {
				var result = [];
				var params = decodeURIComponent($.param(input)).split('&');

				// Loop over params
				$.each(params, function (index, item) {
					var value = item.split('=');

					// Add item
					result.push({ name: value[0], value: value[1] });
				});

				return result;
			}

			return input;
		}
	};

/***/ },
/* 4 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	/**
	 * Copyright (C) 2014-2017 ServMask Inc.
	 *
	 * This program is free software: you can redistribute it and/or modify
	 * it under the terms of the GNU General Public License as published by
	 * the Free Software Foundation, either version 3 of the License, or
	 * (at your option) any later version.
	 *
	 * This program is distributed in the hope that it will be useful,
	 * but WITHOUT ANY WARRANTY; without even the implied warranty of
	 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 * GNU General Public License for more details.
	 *
	 * You should have received a copy of the GNU General Public License
	 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
	 *
	 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
	 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
	 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
	 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
	 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
	 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
	 */

	var Util = __webpack_require__(3),
	    Modal = __webpack_require__(5),
	    $ = jQuery;

	var Import = function Import() {
		var self = this;

		// Set params
		this.params = [];

		// Set stop flag
		this.stopImport = false;

		// Set modal
		this.modal = new Modal();

		// Set confirm listener
		this.modal.onConfirm = function (options) {
			self.onConfirm(options);
		};

		// Set blogs listener
		this.modal.onBlogs = function (options) {
			self.onBlogs(options);
		};

		// Set stop listener
		this.modal.onStop = function (options) {
			self.onStop(options);
		};
	};

	Import.prototype.setParams = function (params) {
		this.params = Util.list(params);
	};

	Import.prototype.start = function (options, retries) {
		var self = this;
		var retries = retries || 0;

		// Set stop flag
		if (retries === 0) {
			this.stopImport = false;
		}

		// Stop running import
		if (this.stopImport) {
			return;
		}

		// Initializing beforeunload event
		$(window).bind('beforeunload', function () {
			return 'You are about to stop importing your website, are you sure?';
		});

		// Set initial status
		this.setStatus({ type: 'info', message: 'Preparing to import...' });

		// Set params
		var params = this.params.concat({ name: 'secret_key', value: ai1wm_import.secret_key });

		// Set additional params
		if (options) {
			params = params.concat(Util.list(options));
		}

		// Import
		$.post(ai1wm_import.ajax.url, params, null, 'json').done(function () {
			self.getStatus();
		}).done(function (params) {
			if (params) {
				self.run(params);
			}
		}).fail(function () {
			var timeout = retries * 1000;
			if (retries >= 5) {
				return self.setStatus({
					type: 'error',
					message: 'Unable to start the import. Refresh the page and try again'
				});
			}

			retries++;

			setTimeout(self.start.bind(self, options, retries), timeout);
		});
	};

	Import.prototype.run = function (params, retries) {
		var self = this;
		var retries = retries || 0;

		// Stop running import
		if (this.stopImport) {
			return;
		}

		// Import
		$.post(ai1wm_import.ajax.url, params, null, 'json').done(function (params) {
			if (params) {
				self.run(params);
			}
		}).fail(function () {
			var timeout = retries * 1000;

			retries++;

			setTimeout(self.run.bind(self, params, retries), timeout);
		});
	};

	Import.prototype.confirm = function (options, retries) {
		var self = this;
		var retries = retries || 0;

		// Stop running import
		if (this.stopImport) {
			return;
		}

		// Set params
		var params = this.params.concat({ name: 'secret_key', value: ai1wm_import.secret_key }).concat({ name: 'priority', value: 150 });

		// Set additional params
		if (options) {
			params = params.concat(Util.list(options));
		}

		// Confirm
		$.post(ai1wm_import.ajax.url, params, null, 'json').done(function () {
			self.getStatus();
		}).done(function (params) {
			if (params) {
				self.run(params);
			}
		}).fail(function () {
			var timeout = retries * 1000;
			if (retries >= 5) {
				return self.setStatus({
					type: 'error',
					message: 'Unable to confirm the import. Refresh the page and try again'
				});
			}

			retries++;

			setTimeout(self.confirm.bind(self, options, retries), timeout);
		});
	};

	Import.prototype.blogs = function (options, retries) {
		var self = this;
		var retries = retries || 0;

		// Stop running import
		if (this.stopImport) {
			return;
		}

		// Set params
		var params = this.params.concat({ name: 'secret_key', value: ai1wm_import.secret_key }).concat({ name: 'priority', value: 150 });

		// Set additional params
		if (options) {
			params = params.concat(Util.list(options));
		}

		// Blogs
		$.post(ai1wm_import.ajax.url, params, null, 'json').done(function () {
			self.getStatus();
		}).done(function (params) {
			if (params) {
				self.run(params);
			}
		}).fail(function () {
			var timeout = retries * 1000;
			if (retries >= 5) {
				return self.setStatus({
					type: 'error',
					message: 'Unable to prepare blogs the import. Refresh the page and try again'
				});
			}

			retries++;

			setTimeout(self.blogs.bind(self, options, retries), timeout);
		});
	};

	Import.prototype.clean = function (options, retries) {
		var self = this;
		var retries = retries || 0;

		// Set stop flag
		this.stopImport = true;

		// Set initial status
		this.setStatus({ type: 'info', message: 'Please wait, stopping the import...' });

		// Set params
		var params = this.params.concat({ name: 'secret_key', value: ai1wm_import.secret_key }).concat({ name: 'priority', value: 400 });

		// Set additional params
		if (options) {
			params = params.concat(Util.list(options));
		}

		// Clean
		$.post(ai1wm_import.ajax.url, params, null, 'json').done(function () {
			// Unbinding the beforeunload event when we stop importing
			$(window).unbind('beforeunload');

			// Destroy modal
			self.modal.destroy();
		}).fail(function () {
			var timeout = retries * 1000;
			if (retries >= 5) {
				return self.setStatus({
					type: 'error',
					message: 'Unable to stop the import. Refresh the page and try again'
				});
			}

			retries++;

			setTimeout(self.clean.bind(self, options, retries), timeout);
		});
	};

	Import.prototype.getStatus = function () {
		var self = this;

		// Stop getting status
		if (this.stopImport) {
			return;
		}

		$.ajax({
			cache: false,
			url: ai1wm_import.status.url,
			dataType: 'json'
		}).done(function (params) {
			if (params) {
				self.setStatus(params);

				// Next status
				switch (params.type) {
					case 'done':
					case 'error':
						// Unbinding the beforeunload event when any case is performed
						$(window).unbind('beforeunload');
						return;

					case 'confirm':
					case 'blogs':
						return;
				}
			}

			// Import is not done yet, let's check status in 3 seconds
			setTimeout(self.getStatus.bind(self), 3000);
		}).fail(function () {
			// Import is not done yet, let's check status in 3 seconds
			setTimeout(self.getStatus.bind(self), 3000);
		});;
	};

	Import.prototype.setStatus = function (params) {
		this.modal.render(params);
	};

	Import.prototype.onConfirm = function (options) {
		this.confirm(options);
	};

	Import.prototype.onBlogs = function (options) {
		this.blogs(options);
	};

	Import.prototype.onStop = function (options) {
		this.clean(options);
	};

	module.exports = Import;

/***/ },
/* 5 */
/***/ function(module, exports) {

	'use strict';

	/**
	 * Copyright (C) 2014-2017 ServMask Inc.
	 *
	 * This program is free software: you can redistribute it and/or modify
	 * it under the terms of the GNU General Public License as published by
	 * the Free Software Foundation, either version 3 of the License, or
	 * (at your option) any later version.
	 *
	 * This program is distributed in the hope that it will be useful,
	 * but WITHOUT ANY WARRANTY; without even the implied warranty of
	 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 * GNU General Public License for more details.
	 *
	 * You should have received a copy of the GNU General Public License
	 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
	 *
	 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
	 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
	 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
	 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
	 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
	 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
	 */

	var $ = jQuery;

	var Modal = function Modal() {
		var self = this;
		this.view = null;

		// Error Modal
		this.error = function (params) {

			// Create the modal container
			var container = $('<div></div>');

			// Create section to hold title, message and action
			var section = $('<section></section>');

			// Create header to hold title
			var header = $('<h1></h1>');

			// Create paragraph to hold mesage
			var message = $('<p></p>').html(params.message);

			// Create action section
			var action = $('<div></div>');

			// Create title
			var title = $('<span></span>').addClass('ai1wm-title-red').text('Unable to import');

			// Create close button
			var closeButton = $('<button type="button" class="ai1wm-button-red">Close</button>').on('click', function () {
				self.destroy();
			});

			// Append close button
			action.append(closeButton);

			// Append title to section
			header.append(title);

			// Append header and message to section
			section.append(header).append(message);

			// Append section and action to container
			container.append(section).append(action);

			// Render modal
			self.modal.html(container).show();
			self.overlay.show();
		};

		// Progress Modal
		this.progress = function (params) {
			if (this.view === 'progress') {

				// Update progressBarMeter
				this.progress.progressBarMeter.width(params.percent + '%');

				// Update progressBarPercent
				this.progress.progressBarPercent.text(params.percent + '%');
			} else {

				// Create the modal container
				var container = $('<div></div>');

				// Create section to hold title, message and action
				var section = $('<section></section>');

				// Create header to hold progress bar
				var header = $('<h1></h1>');

				// Create paragraph to hold mesage
				var message = $('<p></p>');

				// Create action section
				var action = $('<div></div>');

				// Create progressBar
				var progressBar = $('<span class="ai1wm-progress-bar"></span>');

				// Create progressBarMeter
				this.progress.progressBarMeter = $('<span class="ai1wm-progress-bar-meter"></span>').width(params.percent + '%');

				// Create progressBarPercent
				this.progress.progressBarPercent = $('<span class="ai1wm-progress-bar-percent">0%</span>').text(params.percent + '%');

				// Create stop import
				var stopButton = $('<button type="button" class="ai1wm-button-red"><i class="ai1wm-icon-notification"></i> Stop import</button>').on('click', function () {
					$(this).attr('disabled', 'disabled');
					self.onStop();
				});

				// Append progress meter and progress percent
				progressBar.append(this.progress.progressBarMeter).append(this.progress.progressBarPercent);

				// Append stop button
				action.append(stopButton);

				// Append progress bar to section
				header.append(progressBar);

				// Append header to section
				section.append(header);

				// Append section and action to container
				container.append(section).append(action);

				// Render modal
				self.modal.html(container).show();
				self.overlay.show();
			}
		};

		// Confirm Modal
		this.confirm = function (params) {

			// Create the modal container
			var container = $('<div></div>');

			// Create section to hold title, message and action
			var section = $('<section></section>');

			// Create header to hold warning
			var header = $('<h1></h1>');

			// Create paragraph to hold mesage
			var message = $('<p></p>').html(params.message);

			// Create action section
			var action = $('<div></div>');

			// Create warning
			var warning = $('<span class="ai1wm-icon-notification"></span>');

			// Create confirm button
			var confirmButton = $('<button type="button" class="ai1wm-button-green">Continue</button>').on('click', function () {
				$(this).attr('disabled', 'disabled');
				self.onConfirm();
			});

			// Append confirm button
			action.append(confirmButton);

			// Append warning to section
			header.append(warning);

			// Append header and message to section
			section.append(header).append(message);

			// Append section and action to container
			container.append(section).append(action);

			// Render modal
			self.modal.html(container).show();
			self.overlay.show();
		};

		// Blogs Modal
		this.blogs = function (params) {

			// Create the modal container
			var container = $('<form></form>');

			// Create section to hold title, message and action
			var section = $('<section></section>');

			// Create header to hold title
			var header = $('<h1></h1>');

			// Create paragraph to hold mesage
			var message = $('<p></p>').html(params.message);

			// Create action section
			var action = $('<div></div>');

			// Create title
			var title = $('<span></span>').addClass('ai1wm-title-grey').text(params.title);

			// Create continue button
			var continueButton = $('<button type="button" class="ai1wm-button-green">Continue</button>').on('click', function () {
				$(this).attr('disabled', 'disabled');
				self.onBlogs($(this).closest('form').serializeArray());
			});

			// Append continue button
			action.append(continueButton);

			// Append title to section
			header.append(title);

			// Append header and message to section
			section.append(header).append(message);

			// Append section and action to container
			container.append(section).append(action);

			// Render modal
			self.modal.html(container).show();
			self.overlay.show();
		};

		// Info Modal
		this.info = function (params) {

			// Create the modal container
			var container = $('<div></div>');

			// Create section to hold title, message and action
			var section = $('<section></section>');

			// Create header to hold loader
			var header = $('<h1></h1>');

			// Create paragraph to hold mesage
			var message = $('<p></p>').html(params.message);

			// Create action section
			var action = $('<div></div>');

			// Create loader
			var loader = $('<span class="ai1wm-loader"></span>');

			// Create stop import
			var stopButton = $('<button type="button" class="ai1wm-button-red"><i class="ai1wm-icon-notification"></i> Stop import</button>').attr('disabled', 'disabled');

			// Append stop button
			action.append(stopButton);

			// Append loader to header
			header.append(loader);

			// Append header and message to section
			section.append(header).append(message);

			// Append section and action to container
			container.append(section).append(action);

			// Render modal
			self.modal.html(container).show();
			self.overlay.show();
		};

		// Done Modal
		this.done = function (params) {

			// Create the modal container
			var container = $('<div></div>');

			// Create section to hold title, message and action
			var section = $('<section></section>');

			// Create header to hold title
			var header = $('<h1></h1>');

			// Create paragraph to hold mesage
			var message = $('<p></p>').html(params.message);

			// Create action section
			var action = $('<div></div>');

			// Create title
			var title = $('<span></span>').addClass('ai1wm-title-green').text(params.title);

			// Create close button
			var closeButton = $('<button type="button" class="ai1wm-button-red">Close</button>').on('click', function () {
				self.destroy();
			});

			// Append close button
			action.append(closeButton);

			// Append title to section
			header.append(title);

			// Append header and message to section
			section.append(header).append(message);

			// Append section and action to container
			container.append(section).append(action);

			// Render modal
			self.modal.html(container).show();
			self.overlay.show();
		};

		// Create the overlay
		this.overlay = $('<div class="ai1wm-overlay"></div>');

		// Create the modal container
		this.modal = $('<div class="ai1wm-modal-container"></div>');

		$('body').append(this.overlay) // Append overlay to body
		.append(this.modal); // Append modal to body
	};

	Modal.prototype.render = function (params) {

		// Show modal
		switch (params.type) {
			case 'error':
				this.error(params);
				break;

			case 'confirm':
				this.confirm(params);
				break;

			case 'blogs':
				this.blogs(params);
				break;

			case 'progress':
				this.progress(params);
				break;

			case 'info':
				this.info(params);
				break;

			case 'done':
				this.done(params);
				break;
		}

		this.view = params.type;
	};

	Modal.prototype.destroy = function () {
		this.modal.hide();
		this.overlay.hide();
	};

	module.exports = Modal;

/***/ },
/* 6 */,
/* 7 */,
/* 8 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	/**
	 * Copyright (C) 2014-2017 ServMask Inc.
	 *
	 * This program is free software: you can redistribute it and/or modify
	 * it under the terms of the GNU General Public License as published by
	 * the Free Software Foundation, either version 3 of the License, or
	 * (at your option) any later version.
	 *
	 * This program is distributed in the hope that it will be useful,
	 * but WITHOUT ANY WARRANTY; without even the implied warranty of
	 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 * GNU General Public License for more details.
	 *
	 * You should have received a copy of the GNU General Public License
	 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
	 *
	 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
	 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
	 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
	 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
	 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
	 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
	 */

	var Util = __webpack_require__(3),
	    Dialog = __webpack_require__(9);

	var Extensions = {
		's3': 'Amazon S3 Extension',
		'url': 'URL Extension',
		'ftp': 'FTP Extension',
		'gdrive': 'Google Drive Extension',
		'dropbox': 'Dropbox Extension'
	};

	window.Ai1wmExportController = function (provider) {
		this._export = {};
		this._provider = provider;
	};

	window.Ai1wmExportController.prototype.start = function () {
		new Dialog('<strong>All in One WP Migration</strong> is not compatible with current version of ' + '<strong>' + Extensions[this._provider] + '</strong>. Please contact ' + '<a href="mailto:support@servmask.com">support@servmask.com</a> for more details.');
	};

	window.Ai1wmImportController = function (provider) {
		this._import = {};
		this._provider = provider;
	};

	window.Ai1wmImportController.prototype.init = function () {};

	window.Ai1wmImportController.prototype.download = function () {
		new Dialog('<strong>All in One WP Migration</strong> is not compatible with current version of ' + '<strong>' + Extensions[this._provider] + '</strong>. Please contact ' + '<a href="mailto:support@servmask.com">support@servmask.com</a> for more details.');
	};

	jQuery(document).ready(function ($) {
		'use strict';

		// Box extension

		$('#ai1wmbe-import-file-cancel').attr('type', 'button');
		$('#ai1wmbe-import-file').attr('type', 'button');

		// Dropbox extension
		$('#ai1wmde-import-file-cancel').attr('type', 'button');
		$('#ai1wmde-import-file').attr('type', 'button');

		// FTP extension
		$('#ai1wmfe-import-file-cancel').attr('type', 'button');
		$('#ai1wmfe-import-file').attr('type', 'button');

		// Google Drive extension
		$('#ai1wmge-import-file-cancel').attr('type', 'button');
		$('#ai1wmge-import-file').attr('type', 'button');

		// OneDrive extension
		$('#ai1wmoe-import-file-cancel').attr('type', 'button');
		$('#ai1wmoe-import-file').attr('type', 'button');

		// Amazon S3 extension
		$('#ai1wmse-import-file-cancel').attr('type', 'button');
		$('#ai1wmse-import-file').attr('type', 'button');

		// URL extension
		$('#ai1wmle-import-file-cancel').attr('type', 'button');
		$('#ai1wmle-import-file').attr('type', 'button');
	});

/***/ },
/* 9 */
/***/ function(module, exports) {

	'use strict';

	/**
	 * Copyright (C) 2014-2017 ServMask Inc.
	 *
	 * This program is free software: you can redistribute it and/or modify
	 * it under the terms of the GNU General Public License as published by
	 * the Free Software Foundation, either version 3 of the License, or
	 * (at your option) any later version.
	 *
	 * This program is distributed in the hope that it will be useful,
	 * but WITHOUT ANY WARRANTY; without even the implied warranty of
	 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 * GNU General Public License for more details.
	 *
	 * You should have received a copy of the GNU General Public License
	 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
	 *
	 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
	 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
	 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
	 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
	 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
	 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
	 */

	var $ = jQuery;

	var Dialog = function Dialog(text) {
		var self = this;

		// Create the overlay
		this.overlay = $('<div class="ai1wm-overlay"></div>');

		// Create the modal container
		this.container = $('<div></div>');

		// Create the modal container
		this.modal = $('<div class="ai1wm-modal-container"></div>');

		// Create section to hold title, message and action
		this.section = $('<section></section>');

		// Create paragraph to hold mesage
		this.message = $('<p></p>').addClass('ai1wm-dialog-message').html(text);

		// Create action section
		this.action = $('<div></div>');

		// Create close button
		this.closeButton = $('<button type="button" class="ai1wm-button-red">Close</button>').on('click', function () {
			self.modal.hide();
			self.overlay.hide();
		});

		// Append close button
		this.action.append(this.closeButton);

		// Append message to section
		this.section.append(this.message);

		// Append section and action to container
		this.container.append(this.section).append(this.action);

		// Render modal
		this.modal.html(this.container).show();
		this.overlay.show();

		$('body').append(this.overlay).append(this.modal);
	};

	module.exports = Dialog;

/***/ },
/* 10 */,
/* 11 */,
/* 12 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(fetch, global) {'use strict';

	/**
	 * Copyright (C) 2014-2017 ServMask Inc.
	 *
	 * This program is free software: you can redistribute it and/or modify
	 * it under the terms of the GNU General Public License as published by
	 * the Free Software Foundation, either version 3 of the License, or
	 * (at your option) any later version.
	 *
	 * This program is distributed in the hope that it will be useful,
	 * but WITHOUT ANY WARRANTY; without even the implied warranty of
	 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 * GNU General Public License for more details.
	 *
	 * You should have received a copy of the GNU General Public License
	 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
	 *
	 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
	 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
	 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
	 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
	 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
	 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
	 */

	var Util = __webpack_require__(3),
	    Import = __webpack_require__(4),
	    $ = jQuery;

	var FileUploader = function FileUploader() {};

	FileUploader.prototype.setDefaultValues = function () {
		this.model = new Import();
		this.stopUpload = false;
	};

	FileUploader.prototype.init = function () {
		var _this = this;

		var selectElement = $('#ai1wm-import-file');
		var dropElement = $('#ai1wm-drag-drop-area');

		selectElement.on('change', function (event) {
			event.preventDefault();
			_this.setDefaultValues();
			var file = event.target.files.item(0);
			_this.setDefaultValues();
			_this.fileSize = file.size;
			try {
				_this.onFilesAdded(file);
				_this.onBeforeUpload(file);
				_this.upload(file);
			} catch (exception) {
				_this.onError(exception);
			}
		});

		dropElement.on('dragenter', function (event) {
			event.preventDefault();
			dropElement.addClass('ai1wm-drag-over');
		});
		dropElement.on('dragover', function (event) {
			event.preventDefault();
			dropElement.addClass('ai1wm-drag-over');
		});
		dropElement.on('dragleave', function (event) {
			event.preventDefault();
			dropElement.removeClass('ai1wm-drag-over');
		});
		dropElement.on('drop', function (event) {
			event.preventDefault();
			_this.setDefaultValues();
			dropElement.removeClass('ai1wm-drag-over');
			var file = event.originalEvent.dataTransfer.files.item(0);
			_this.fileSize = file.size;
			try {
				_this.onFilesAdded(file);
				_this.onBeforeUpload(file);
				_this.upload(file);
			} catch (exception) {
				_this.onError(exception);
			}
		});
	};

	FileUploader.prototype.upload = function (file, retries) {
		var _this2 = this;

		var retries = retries || 0;

		var chunkSize = file.size > ai1wm_uploader.chunk_size ? ai1wm_uploader.chunk_size : file.size;
		var formData = this.getFormData(file, chunkSize);

		fetch(ai1wm_uploader.url, {
			method: 'POST',
			credentials: 'include',
			body: formData
		}).then(function (response) {
			if (_this2.stopUpload) {
				return;
			}

			switch (response.status) {
				case 413:
					ai1wm_uploader.chunk_size = chunkSize / 2;
					return _this2.upload(file);
				case 200:
					file = file.slice(chunkSize, file.size, 'application/octet-binary');
					var uploadedBytes = _this2.fileSize - file.size;
					var progress = uploadedBytes / _this2.fileSize * 100;
					_this2.onUploadProgress(progress.toFixed(2));
					return progress === 100 ? _this2.onFileUploaded() : _this2.upload(file);
				default:
					throw new Error(response.status);
			}
		}).catch(function (error) {
			var timeout = retries * 1000;
			if (retries >= 30) {
				return _this2.onError(new Error('We are sorry, there seems to be a problem while uploading your file. Follow <a href="https://www.youtube.com/watch?v=mRp7qTFYKgs" target="_blank">this guide</a> to resolve it.'));
			}

			retries++;

			setTimeout(_this2.upload.bind(_this2, file, retries), timeout);
		});
	};

	FileUploader.prototype.getFormData = function (file, chunkSize) {
		var params = ai1wm_uploader.params;
		var formData = new FormData();
		formData.append('upload-file', file.slice(0, chunkSize, 'application/octet-binary'));

		for (var name in params) {
			formData.append(name, params[name]);
		}

		return formData;
	};

	FileUploader.prototype.checkSize = function (file) {
		var size = parseInt(ai1wm_uploader.filters.ai1wm_archive_size, 10);

		if (file.size > size && size !== 0) {
			throw new Error(ai1wm_import.oversize);
		}
	};

	FileUploader.prototype.checkExtension = function (file) {
		var extensions = ai1wm_uploader.filters.ai1wm_archive_extension;

		var matchExtension = extensions.some(function (extension) {
			return file.name.substr(-extension.length) === extension;
		});

		if (!matchExtension) {
			throw new Error(ai1wm_import.invalid_extension);
		}
	};

	FileUploader.prototype.onFilesAdded = function (file) {
		this.checkExtension(file);
		this.checkSize(file);

		// Initializing beforeunload event
		$(window).bind('beforeunload', function () {
			return 'You are about to stop importing your website, are you sure?';
		});
	};

	FileUploader.prototype.onBeforeUpload = function (file) {
		var self = this;

		var storage = Util.random(12);
		var options = Util.form('#ai1wm-import-form').concat({ name: 'storage', value: storage }).concat({ name: 'archive', value: file.name });

		// Set global params
		this.model.setParams(options);

		// Set multipart params
		$.extend(ai1wm_uploader.params, {
			storage: storage,
			archive: file.name
		});

		// Set stop
		this.model.onStop = function () {
			self.stopUpload = true;

			// Clean storage
			self.model.clean();
		};

		// Set status
		this.model.setStatus({ type: 'progress', percent: '0.00' });
	};

	FileUploader.prototype.onUploadProgress = function (percent) {
		this.model.setStatus({ type: 'progress', percent: percent });
	};

	FileUploader.prototype.onFileUploaded = function () {
		this.model.start();
	};

	FileUploader.prototype.onError = function (error) {
		this.model.setStatus({ type: 'error', message: error.message });
	};

	module.exports = FileUploader;

	global.Ai1wm = { Util: Util, Import: Import };
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(13), (function() { return this; }())))

/***/ },
/* 13 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Promise, global) {/*** IMPORTS FROM imports-loader ***/
	(function() {

	(function(self) {
	  'use strict';

	  if (self.fetch) {
	    return
	  }

	  var support = {
	    searchParams: 'URLSearchParams' in self,
	    iterable: 'Symbol' in self && 'iterator' in Symbol,
	    blob: 'FileReader' in self && 'Blob' in self && (function() {
	      try {
	        new Blob()
	        return true
	      } catch(e) {
	        return false
	      }
	    })(),
	    formData: 'FormData' in self,
	    arrayBuffer: 'ArrayBuffer' in self
	  }

	  if (support.arrayBuffer) {
	    var viewClasses = [
	      '[object Int8Array]',
	      '[object Uint8Array]',
	      '[object Uint8ClampedArray]',
	      '[object Int16Array]',
	      '[object Uint16Array]',
	      '[object Int32Array]',
	      '[object Uint32Array]',
	      '[object Float32Array]',
	      '[object Float64Array]'
	    ]

	    var isDataView = function(obj) {
	      return obj && DataView.prototype.isPrototypeOf(obj)
	    }

	    var isArrayBufferView = ArrayBuffer.isView || function(obj) {
	      return obj && viewClasses.indexOf(Object.prototype.toString.call(obj)) > -1
	    }
	  }

	  function normalizeName(name) {
	    if (typeof name !== 'string') {
	      name = String(name)
	    }
	    if (/[^a-z0-9\-#$%&'*+.\^_`|~]/i.test(name)) {
	      throw new TypeError('Invalid character in header field name')
	    }
	    return name.toLowerCase()
	  }

	  function normalizeValue(value) {
	    if (typeof value !== 'string') {
	      value = String(value)
	    }
	    return value
	  }

	  // Build a destructive iterator for the value list
	  function iteratorFor(items) {
	    var iterator = {
	      next: function() {
	        var value = items.shift()
	        return {done: value === undefined, value: value}
	      }
	    }

	    if (support.iterable) {
	      iterator[Symbol.iterator] = function() {
	        return iterator
	      }
	    }

	    return iterator
	  }

	  function Headers(headers) {
	    this.map = {}

	    if (headers instanceof Headers) {
	      headers.forEach(function(value, name) {
	        this.append(name, value)
	      }, this)

	    } else if (headers) {
	      Object.getOwnPropertyNames(headers).forEach(function(name) {
	        this.append(name, headers[name])
	      }, this)
	    }
	  }

	  Headers.prototype.append = function(name, value) {
	    name = normalizeName(name)
	    value = normalizeValue(value)
	    var list = this.map[name]
	    if (!list) {
	      list = []
	      this.map[name] = list
	    }
	    list.push(value)
	  }

	  Headers.prototype['delete'] = function(name) {
	    delete this.map[normalizeName(name)]
	  }

	  Headers.prototype.get = function(name) {
	    var values = this.map[normalizeName(name)]
	    return values ? values[0] : null
	  }

	  Headers.prototype.getAll = function(name) {
	    return this.map[normalizeName(name)] || []
	  }

	  Headers.prototype.has = function(name) {
	    return this.map.hasOwnProperty(normalizeName(name))
	  }

	  Headers.prototype.set = function(name, value) {
	    this.map[normalizeName(name)] = [normalizeValue(value)]
	  }

	  Headers.prototype.forEach = function(callback, thisArg) {
	    Object.getOwnPropertyNames(this.map).forEach(function(name) {
	      this.map[name].forEach(function(value) {
	        callback.call(thisArg, value, name, this)
	      }, this)
	    }, this)
	  }

	  Headers.prototype.keys = function() {
	    var items = []
	    this.forEach(function(value, name) { items.push(name) })
	    return iteratorFor(items)
	  }

	  Headers.prototype.values = function() {
	    var items = []
	    this.forEach(function(value) { items.push(value) })
	    return iteratorFor(items)
	  }

	  Headers.prototype.entries = function() {
	    var items = []
	    this.forEach(function(value, name) { items.push([name, value]) })
	    return iteratorFor(items)
	  }

	  if (support.iterable) {
	    Headers.prototype[Symbol.iterator] = Headers.prototype.entries
	  }

	  function consumed(body) {
	    if (body.bodyUsed) {
	      return Promise.reject(new TypeError('Already read'))
	    }
	    body.bodyUsed = true
	  }

	  function fileReaderReady(reader) {
	    return new Promise(function(resolve, reject) {
	      reader.onload = function() {
	        resolve(reader.result)
	      }
	      reader.onerror = function() {
	        reject(reader.error)
	      }
	    })
	  }

	  function readBlobAsArrayBuffer(blob) {
	    var reader = new FileReader()
	    var promise = fileReaderReady(reader)
	    reader.readAsArrayBuffer(blob)
	    return promise
	  }

	  function readBlobAsText(blob) {
	    var reader = new FileReader()
	    var promise = fileReaderReady(reader)
	    reader.readAsText(blob)
	    return promise
	  }

	  function readArrayBufferAsText(buf) {
	    var view = new Uint8Array(buf)
	    var chars = new Array(view.length)

	    for (var i = 0; i < view.length; i++) {
	      chars[i] = String.fromCharCode(view[i])
	    }
	    return chars.join('')
	  }

	  function bufferClone(buf) {
	    if (buf.slice) {
	      return buf.slice(0)
	    } else {
	      var view = new Uint8Array(buf.byteLength)
	      view.set(new Uint8Array(buf))
	      return view.buffer
	    }
	  }

	  function Body() {
	    this.bodyUsed = false

	    this._initBody = function(body) {
	      this._bodyInit = body
	      if (!body) {
	        this._bodyText = ''
	      } else if (typeof body === 'string') {
	        this._bodyText = body
	      } else if (support.blob && Blob.prototype.isPrototypeOf(body)) {
	        this._bodyBlob = body
	      } else if (support.formData && FormData.prototype.isPrototypeOf(body)) {
	        this._bodyFormData = body
	      } else if (support.searchParams && URLSearchParams.prototype.isPrototypeOf(body)) {
	        this._bodyText = body.toString()
	      } else if (support.arrayBuffer && support.blob && isDataView(body)) {
	        this._bodyArrayBuffer = bufferClone(body.buffer)
	        // IE 10-11 can't handle a DataView body.
	        this._bodyInit = new Blob([this._bodyArrayBuffer])
	      } else if (support.arrayBuffer && (ArrayBuffer.prototype.isPrototypeOf(body) || isArrayBufferView(body))) {
	        this._bodyArrayBuffer = bufferClone(body)
	      } else {
	        throw new Error('unsupported BodyInit type')
	      }

	      if (!this.headers.get('content-type')) {
	        if (typeof body === 'string') {
	          this.headers.set('content-type', 'text/plain;charset=UTF-8')
	        } else if (this._bodyBlob && this._bodyBlob.type) {
	          this.headers.set('content-type', this._bodyBlob.type)
	        } else if (support.searchParams && URLSearchParams.prototype.isPrototypeOf(body)) {
	          this.headers.set('content-type', 'application/x-www-form-urlencoded;charset=UTF-8')
	        }
	      }
	    }

	    if (support.blob) {
	      this.blob = function() {
	        var rejected = consumed(this)
	        if (rejected) {
	          return rejected
	        }

	        if (this._bodyBlob) {
	          return Promise.resolve(this._bodyBlob)
	        } else if (this._bodyArrayBuffer) {
	          return Promise.resolve(new Blob([this._bodyArrayBuffer]))
	        } else if (this._bodyFormData) {
	          throw new Error('could not read FormData body as blob')
	        } else {
	          return Promise.resolve(new Blob([this._bodyText]))
	        }
	      }

	      this.arrayBuffer = function() {
	        if (this._bodyArrayBuffer) {
	          return consumed(this) || Promise.resolve(this._bodyArrayBuffer)
	        } else {
	          return this.blob().then(readBlobAsArrayBuffer)
	        }
	      }
	    }

	    this.text = function() {
	      var rejected = consumed(this)
	      if (rejected) {
	        return rejected
	      }

	      if (this._bodyBlob) {
	        return readBlobAsText(this._bodyBlob)
	      } else if (this._bodyArrayBuffer) {
	        return Promise.resolve(readArrayBufferAsText(this._bodyArrayBuffer))
	      } else if (this._bodyFormData) {
	        throw new Error('could not read FormData body as text')
	      } else {
	        return Promise.resolve(this._bodyText)
	      }
	    }

	    if (support.formData) {
	      this.formData = function() {
	        return this.text().then(decode)
	      }
	    }

	    this.json = function() {
	      return this.text().then(JSON.parse)
	    }

	    return this
	  }

	  // HTTP methods whose capitalization should be normalized
	  var methods = ['DELETE', 'GET', 'HEAD', 'OPTIONS', 'POST', 'PUT']

	  function normalizeMethod(method) {
	    var upcased = method.toUpperCase()
	    return (methods.indexOf(upcased) > -1) ? upcased : method
	  }

	  function Request(input, options) {
	    options = options || {}
	    var body = options.body

	    if (typeof input === 'string') {
	      this.url = input
	    } else {
	      if (input.bodyUsed) {
	        throw new TypeError('Already read')
	      }
	      this.url = input.url
	      this.credentials = input.credentials
	      if (!options.headers) {
	        this.headers = new Headers(input.headers)
	      }
	      this.method = input.method
	      this.mode = input.mode
	      if (!body && input._bodyInit != null) {
	        body = input._bodyInit
	        input.bodyUsed = true
	      }
	    }

	    this.credentials = options.credentials || this.credentials || 'omit'
	    if (options.headers || !this.headers) {
	      this.headers = new Headers(options.headers)
	    }
	    this.method = normalizeMethod(options.method || this.method || 'GET')
	    this.mode = options.mode || this.mode || null
	    this.referrer = null

	    if ((this.method === 'GET' || this.method === 'HEAD') && body) {
	      throw new TypeError('Body not allowed for GET or HEAD requests')
	    }
	    this._initBody(body)
	  }

	  Request.prototype.clone = function() {
	    return new Request(this, { body: this._bodyInit })
	  }

	  function decode(body) {
	    var form = new FormData()
	    body.trim().split('&').forEach(function(bytes) {
	      if (bytes) {
	        var split = bytes.split('=')
	        var name = split.shift().replace(/\+/g, ' ')
	        var value = split.join('=').replace(/\+/g, ' ')
	        form.append(decodeURIComponent(name), decodeURIComponent(value))
	      }
	    })
	    return form
	  }

	  function parseHeaders(rawHeaders) {
	    var headers = new Headers()
	    rawHeaders.split('\r\n').forEach(function(line) {
	      var parts = line.split(':')
	      var key = parts.shift().trim()
	      if (key) {
	        var value = parts.join(':').trim()
	        headers.append(key, value)
	      }
	    })
	    return headers
	  }

	  Body.call(Request.prototype)

	  function Response(bodyInit, options) {
	    if (!options) {
	      options = {}
	    }

	    this.type = 'default'
	    this.status = 'status' in options ? options.status : 200
	    this.ok = this.status >= 200 && this.status < 300
	    this.statusText = 'statusText' in options ? options.statusText : 'OK'
	    this.headers = new Headers(options.headers)
	    this.url = options.url || ''
	    this._initBody(bodyInit)
	  }

	  Body.call(Response.prototype)

	  Response.prototype.clone = function() {
	    return new Response(this._bodyInit, {
	      status: this.status,
	      statusText: this.statusText,
	      headers: new Headers(this.headers),
	      url: this.url
	    })
	  }

	  Response.error = function() {
	    var response = new Response(null, {status: 0, statusText: ''})
	    response.type = 'error'
	    return response
	  }

	  var redirectStatuses = [301, 302, 303, 307, 308]

	  Response.redirect = function(url, status) {
	    if (redirectStatuses.indexOf(status) === -1) {
	      throw new RangeError('Invalid status code')
	    }

	    return new Response(null, {status: status, headers: {location: url}})
	  }

	  self.Headers = Headers
	  self.Request = Request
	  self.Response = Response

	  self.fetch = function(input, init) {
	    return new Promise(function(resolve, reject) {
	      var request = new Request(input, init)
	      var xhr = new XMLHttpRequest()

	      xhr.onload = function() {
	        var options = {
	          status: xhr.status,
	          statusText: xhr.statusText,
	          headers: parseHeaders(xhr.getAllResponseHeaders() || '')
	        }
	        options.url = 'responseURL' in xhr ? xhr.responseURL : options.headers.get('X-Request-URL')
	        var body = 'response' in xhr ? xhr.response : xhr.responseText
	        resolve(new Response(body, options))
	      }

	      xhr.onerror = function() {
	        reject(new TypeError('Network request failed'))
	      }

	      xhr.ontimeout = function() {
	        reject(new TypeError('Network request failed'))
	      }

	      xhr.open(request.method, request.url, true)

	      if (request.credentials === 'include') {
	        xhr.withCredentials = true
	      }

	      if ('responseType' in xhr && support.blob) {
	        xhr.responseType = 'blob'
	      }

	      request.headers.forEach(function(value, name) {
	        xhr.setRequestHeader(name, value)
	      })

	      xhr.send(typeof request._bodyInit === 'undefined' ? null : request._bodyInit)
	    })
	  }
	  self.fetch.polyfill = true
	})(typeof self !== 'undefined' ? self : this);


	/*** EXPORTS FROM exports-loader ***/
	module.exports = global.fetch;
	}.call(global));
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(14), (function() { return this; }())))

/***/ },
/* 14 */
/***/ function(module, exports, __webpack_require__) {

	var require;/* WEBPACK VAR INJECTION */(function(process, Promise, global) {/*** IMPORTS FROM imports-loader ***/
	(function() {

	/*!
	 * @overview es6-promise - a tiny implementation of Promises/A+.
	 * @copyright Copyright (c) 2014 Yehuda Katz, Tom Dale, Stefan Penner and contributors (Conversion to ES6 API by Jake Archibald)
	 * @license   Licensed under MIT license
	 *            See https://raw.githubusercontent.com/stefanpenner/es6-promise/master/LICENSE
	 * @version   3.3.1
	 */

	(function (global, factory) {
	     true ? module.exports = factory() :
	    typeof define === 'function' && define.amd ? define(factory) :
	    (global.ES6Promise = factory());
	}(this, (function () { 'use strict';

	function objectOrFunction(x) {
	  return typeof x === 'function' || typeof x === 'object' && x !== null;
	}

	function isFunction(x) {
	  return typeof x === 'function';
	}

	var _isArray = undefined;
	if (!Array.isArray) {
	  _isArray = function (x) {
	    return Object.prototype.toString.call(x) === '[object Array]';
	  };
	} else {
	  _isArray = Array.isArray;
	}

	var isArray = _isArray;

	var len = 0;
	var vertxNext = undefined;
	var customSchedulerFn = undefined;

	var asap = function asap(callback, arg) {
	  queue[len] = callback;
	  queue[len + 1] = arg;
	  len += 2;
	  if (len === 2) {
	    // If len is 2, that means that we need to schedule an async flush.
	    // If additional callbacks are queued before the queue is flushed, they
	    // will be processed by this flush that we are scheduling.
	    if (customSchedulerFn) {
	      customSchedulerFn(flush);
	    } else {
	      scheduleFlush();
	    }
	  }
	};

	function setScheduler(scheduleFn) {
	  customSchedulerFn = scheduleFn;
	}

	function setAsap(asapFn) {
	  asap = asapFn;
	}

	var browserWindow = typeof window !== 'undefined' ? window : undefined;
	var browserGlobal = browserWindow || {};
	var BrowserMutationObserver = browserGlobal.MutationObserver || browserGlobal.WebKitMutationObserver;
	var isNode = typeof self === 'undefined' && typeof process !== 'undefined' && ({}).toString.call(process) === '[object process]';

	// test for web worker but not in IE10
	var isWorker = typeof Uint8ClampedArray !== 'undefined' && typeof importScripts !== 'undefined' && typeof MessageChannel !== 'undefined';

	// node
	function useNextTick() {
	  // node version 0.10.x displays a deprecation warning when nextTick is used recursively
	  // see https://github.com/cujojs/when/issues/410 for details
	  return function () {
	    return process.nextTick(flush);
	  };
	}

	// vertx
	function useVertxTimer() {
	  return function () {
	    vertxNext(flush);
	  };
	}

	function useMutationObserver() {
	  var iterations = 0;
	  var observer = new BrowserMutationObserver(flush);
	  var node = document.createTextNode('');
	  observer.observe(node, { characterData: true });

	  return function () {
	    node.data = iterations = ++iterations % 2;
	  };
	}

	// web worker
	function useMessageChannel() {
	  var channel = new MessageChannel();
	  channel.port1.onmessage = flush;
	  return function () {
	    return channel.port2.postMessage(0);
	  };
	}

	function useSetTimeout() {
	  // Store setTimeout reference so es6-promise will be unaffected by
	  // other code modifying setTimeout (like sinon.useFakeTimers())
	  var globalSetTimeout = setTimeout;
	  return function () {
	    return globalSetTimeout(flush, 1);
	  };
	}

	var queue = new Array(1000);
	function flush() {
	  for (var i = 0; i < len; i += 2) {
	    var callback = queue[i];
	    var arg = queue[i + 1];

	    callback(arg);

	    queue[i] = undefined;
	    queue[i + 1] = undefined;
	  }

	  len = 0;
	}

	function attemptVertx() {
	  try {
	    var r = require;
	    var vertx = __webpack_require__(16);
	    vertxNext = vertx.runOnLoop || vertx.runOnContext;
	    return useVertxTimer();
	  } catch (e) {
	    return useSetTimeout();
	  }
	}

	var scheduleFlush = undefined;
	// Decide what async method to use to triggering processing of queued callbacks:
	if (isNode) {
	  scheduleFlush = useNextTick();
	} else if (BrowserMutationObserver) {
	  scheduleFlush = useMutationObserver();
	} else if (isWorker) {
	  scheduleFlush = useMessageChannel();
	} else if (browserWindow === undefined && "function" === 'function') {
	  scheduleFlush = attemptVertx();
	} else {
	  scheduleFlush = useSetTimeout();
	}

	function then(onFulfillment, onRejection) {
	  var _arguments = arguments;

	  var parent = this;

	  var child = new this.constructor(noop);

	  if (child[PROMISE_ID] === undefined) {
	    makePromise(child);
	  }

	  var _state = parent._state;

	  if (_state) {
	    (function () {
	      var callback = _arguments[_state - 1];
	      asap(function () {
	        return invokeCallback(_state, child, callback, parent._result);
	      });
	    })();
	  } else {
	    subscribe(parent, child, onFulfillment, onRejection);
	  }

	  return child;
	}

	/**
	  `Promise.resolve` returns a promise that will become resolved with the
	  passed `value`. It is shorthand for the following:

	  ```javascript
	  let promise = new Promise(function(resolve, reject){
	    resolve(1);
	  });

	  promise.then(function(value){
	    // value === 1
	  });
	  ```

	  Instead of writing the above, your code now simply becomes the following:

	  ```javascript
	  let promise = Promise.resolve(1);

	  promise.then(function(value){
	    // value === 1
	  });
	  ```

	  @method resolve
	  @static
	  @param {Any} value value that the returned promise will be resolved with
	  Useful for tooling.
	  @return {Promise} a promise that will become fulfilled with the given
	  `value`
	*/
	function resolve(object) {
	  /*jshint validthis:true */
	  var Constructor = this;

	  if (object && typeof object === 'object' && object.constructor === Constructor) {
	    return object;
	  }

	  var promise = new Constructor(noop);
	  _resolve(promise, object);
	  return promise;
	}

	var PROMISE_ID = Math.random().toString(36).substring(16);

	function noop() {}

	var PENDING = void 0;
	var FULFILLED = 1;
	var REJECTED = 2;

	var GET_THEN_ERROR = new ErrorObject();

	function selfFulfillment() {
	  return new TypeError("You cannot resolve a promise with itself");
	}

	function cannotReturnOwn() {
	  return new TypeError('A promises callback cannot return that same promise.');
	}

	function getThen(promise) {
	  try {
	    return promise.then;
	  } catch (error) {
	    GET_THEN_ERROR.error = error;
	    return GET_THEN_ERROR;
	  }
	}

	function tryThen(then, value, fulfillmentHandler, rejectionHandler) {
	  try {
	    then.call(value, fulfillmentHandler, rejectionHandler);
	  } catch (e) {
	    return e;
	  }
	}

	function handleForeignThenable(promise, thenable, then) {
	  asap(function (promise) {
	    var sealed = false;
	    var error = tryThen(then, thenable, function (value) {
	      if (sealed) {
	        return;
	      }
	      sealed = true;
	      if (thenable !== value) {
	        _resolve(promise, value);
	      } else {
	        fulfill(promise, value);
	      }
	    }, function (reason) {
	      if (sealed) {
	        return;
	      }
	      sealed = true;

	      _reject(promise, reason);
	    }, 'Settle: ' + (promise._label || ' unknown promise'));

	    if (!sealed && error) {
	      sealed = true;
	      _reject(promise, error);
	    }
	  }, promise);
	}

	function handleOwnThenable(promise, thenable) {
	  if (thenable._state === FULFILLED) {
	    fulfill(promise, thenable._result);
	  } else if (thenable._state === REJECTED) {
	    _reject(promise, thenable._result);
	  } else {
	    subscribe(thenable, undefined, function (value) {
	      return _resolve(promise, value);
	    }, function (reason) {
	      return _reject(promise, reason);
	    });
	  }
	}

	function handleMaybeThenable(promise, maybeThenable, then$$) {
	  if (maybeThenable.constructor === promise.constructor && then$$ === then && maybeThenable.constructor.resolve === resolve) {
	    handleOwnThenable(promise, maybeThenable);
	  } else {
	    if (then$$ === GET_THEN_ERROR) {
	      _reject(promise, GET_THEN_ERROR.error);
	    } else if (then$$ === undefined) {
	      fulfill(promise, maybeThenable);
	    } else if (isFunction(then$$)) {
	      handleForeignThenable(promise, maybeThenable, then$$);
	    } else {
	      fulfill(promise, maybeThenable);
	    }
	  }
	}

	function _resolve(promise, value) {
	  if (promise === value) {
	    _reject(promise, selfFulfillment());
	  } else if (objectOrFunction(value)) {
	    handleMaybeThenable(promise, value, getThen(value));
	  } else {
	    fulfill(promise, value);
	  }
	}

	function publishRejection(promise) {
	  if (promise._onerror) {
	    promise._onerror(promise._result);
	  }

	  publish(promise);
	}

	function fulfill(promise, value) {
	  if (promise._state !== PENDING) {
	    return;
	  }

	  promise._result = value;
	  promise._state = FULFILLED;

	  if (promise._subscribers.length !== 0) {
	    asap(publish, promise);
	  }
	}

	function _reject(promise, reason) {
	  if (promise._state !== PENDING) {
	    return;
	  }
	  promise._state = REJECTED;
	  promise._result = reason;

	  asap(publishRejection, promise);
	}

	function subscribe(parent, child, onFulfillment, onRejection) {
	  var _subscribers = parent._subscribers;
	  var length = _subscribers.length;

	  parent._onerror = null;

	  _subscribers[length] = child;
	  _subscribers[length + FULFILLED] = onFulfillment;
	  _subscribers[length + REJECTED] = onRejection;

	  if (length === 0 && parent._state) {
	    asap(publish, parent);
	  }
	}

	function publish(promise) {
	  var subscribers = promise._subscribers;
	  var settled = promise._state;

	  if (subscribers.length === 0) {
	    return;
	  }

	  var child = undefined,
	      callback = undefined,
	      detail = promise._result;

	  for (var i = 0; i < subscribers.length; i += 3) {
	    child = subscribers[i];
	    callback = subscribers[i + settled];

	    if (child) {
	      invokeCallback(settled, child, callback, detail);
	    } else {
	      callback(detail);
	    }
	  }

	  promise._subscribers.length = 0;
	}

	function ErrorObject() {
	  this.error = null;
	}

	var TRY_CATCH_ERROR = new ErrorObject();

	function tryCatch(callback, detail) {
	  try {
	    return callback(detail);
	  } catch (e) {
	    TRY_CATCH_ERROR.error = e;
	    return TRY_CATCH_ERROR;
	  }
	}

	function invokeCallback(settled, promise, callback, detail) {
	  var hasCallback = isFunction(callback),
	      value = undefined,
	      error = undefined,
	      succeeded = undefined,
	      failed = undefined;

	  if (hasCallback) {
	    value = tryCatch(callback, detail);

	    if (value === TRY_CATCH_ERROR) {
	      failed = true;
	      error = value.error;
	      value = null;
	    } else {
	      succeeded = true;
	    }

	    if (promise === value) {
	      _reject(promise, cannotReturnOwn());
	      return;
	    }
	  } else {
	    value = detail;
	    succeeded = true;
	  }

	  if (promise._state !== PENDING) {
	    // noop
	  } else if (hasCallback && succeeded) {
	      _resolve(promise, value);
	    } else if (failed) {
	      _reject(promise, error);
	    } else if (settled === FULFILLED) {
	      fulfill(promise, value);
	    } else if (settled === REJECTED) {
	      _reject(promise, value);
	    }
	}

	function initializePromise(promise, resolver) {
	  try {
	    resolver(function resolvePromise(value) {
	      _resolve(promise, value);
	    }, function rejectPromise(reason) {
	      _reject(promise, reason);
	    });
	  } catch (e) {
	    _reject(promise, e);
	  }
	}

	var id = 0;
	function nextId() {
	  return id++;
	}

	function makePromise(promise) {
	  promise[PROMISE_ID] = id++;
	  promise._state = undefined;
	  promise._result = undefined;
	  promise._subscribers = [];
	}

	function Enumerator(Constructor, input) {
	  this._instanceConstructor = Constructor;
	  this.promise = new Constructor(noop);

	  if (!this.promise[PROMISE_ID]) {
	    makePromise(this.promise);
	  }

	  if (isArray(input)) {
	    this._input = input;
	    this.length = input.length;
	    this._remaining = input.length;

	    this._result = new Array(this.length);

	    if (this.length === 0) {
	      fulfill(this.promise, this._result);
	    } else {
	      this.length = this.length || 0;
	      this._enumerate();
	      if (this._remaining === 0) {
	        fulfill(this.promise, this._result);
	      }
	    }
	  } else {
	    _reject(this.promise, validationError());
	  }
	}

	function validationError() {
	  return new Error('Array Methods must be provided an Array');
	};

	Enumerator.prototype._enumerate = function () {
	  var length = this.length;
	  var _input = this._input;

	  for (var i = 0; this._state === PENDING && i < length; i++) {
	    this._eachEntry(_input[i], i);
	  }
	};

	Enumerator.prototype._eachEntry = function (entry, i) {
	  var c = this._instanceConstructor;
	  var resolve$$ = c.resolve;

	  if (resolve$$ === resolve) {
	    var _then = getThen(entry);

	    if (_then === then && entry._state !== PENDING) {
	      this._settledAt(entry._state, i, entry._result);
	    } else if (typeof _then !== 'function') {
	      this._remaining--;
	      this._result[i] = entry;
	    } else if (c === Promise) {
	      var promise = new c(noop);
	      handleMaybeThenable(promise, entry, _then);
	      this._willSettleAt(promise, i);
	    } else {
	      this._willSettleAt(new c(function (resolve$$) {
	        return resolve$$(entry);
	      }), i);
	    }
	  } else {
	    this._willSettleAt(resolve$$(entry), i);
	  }
	};

	Enumerator.prototype._settledAt = function (state, i, value) {
	  var promise = this.promise;

	  if (promise._state === PENDING) {
	    this._remaining--;

	    if (state === REJECTED) {
	      _reject(promise, value);
	    } else {
	      this._result[i] = value;
	    }
	  }

	  if (this._remaining === 0) {
	    fulfill(promise, this._result);
	  }
	};

	Enumerator.prototype._willSettleAt = function (promise, i) {
	  var enumerator = this;

	  subscribe(promise, undefined, function (value) {
	    return enumerator._settledAt(FULFILLED, i, value);
	  }, function (reason) {
	    return enumerator._settledAt(REJECTED, i, reason);
	  });
	};

	/**
	  `Promise.all` accepts an array of promises, and returns a new promise which
	  is fulfilled with an array of fulfillment values for the passed promises, or
	  rejected with the reason of the first passed promise to be rejected. It casts all
	  elements of the passed iterable to promises as it runs this algorithm.

	  Example:

	  ```javascript
	  let promise1 = resolve(1);
	  let promise2 = resolve(2);
	  let promise3 = resolve(3);
	  let promises = [ promise1, promise2, promise3 ];

	  Promise.all(promises).then(function(array){
	    // The array here would be [ 1, 2, 3 ];
	  });
	  ```

	  If any of the `promises` given to `all` are rejected, the first promise
	  that is rejected will be given as an argument to the returned promises's
	  rejection handler. For example:

	  Example:

	  ```javascript
	  let promise1 = resolve(1);
	  let promise2 = reject(new Error("2"));
	  let promise3 = reject(new Error("3"));
	  let promises = [ promise1, promise2, promise3 ];

	  Promise.all(promises).then(function(array){
	    // Code here never runs because there are rejected promises!
	  }, function(error) {
	    // error.message === "2"
	  });
	  ```

	  @method all
	  @static
	  @param {Array} entries array of promises
	  @param {String} label optional string for labeling the promise.
	  Useful for tooling.
	  @return {Promise} promise that is fulfilled when all `promises` have been
	  fulfilled, or rejected if any of them become rejected.
	  @static
	*/
	function all(entries) {
	  return new Enumerator(this, entries).promise;
	}

	/**
	  `Promise.race` returns a new promise which is settled in the same way as the
	  first passed promise to settle.

	  Example:

	  ```javascript
	  let promise1 = new Promise(function(resolve, reject){
	    setTimeout(function(){
	      resolve('promise 1');
	    }, 200);
	  });

	  let promise2 = new Promise(function(resolve, reject){
	    setTimeout(function(){
	      resolve('promise 2');
	    }, 100);
	  });

	  Promise.race([promise1, promise2]).then(function(result){
	    // result === 'promise 2' because it was resolved before promise1
	    // was resolved.
	  });
	  ```

	  `Promise.race` is deterministic in that only the state of the first
	  settled promise matters. For example, even if other promises given to the
	  `promises` array argument are resolved, but the first settled promise has
	  become rejected before the other promises became fulfilled, the returned
	  promise will become rejected:

	  ```javascript
	  let promise1 = new Promise(function(resolve, reject){
	    setTimeout(function(){
	      resolve('promise 1');
	    }, 200);
	  });

	  let promise2 = new Promise(function(resolve, reject){
	    setTimeout(function(){
	      reject(new Error('promise 2'));
	    }, 100);
	  });

	  Promise.race([promise1, promise2]).then(function(result){
	    // Code here never runs
	  }, function(reason){
	    // reason.message === 'promise 2' because promise 2 became rejected before
	    // promise 1 became fulfilled
	  });
	  ```

	  An example real-world use case is implementing timeouts:

	  ```javascript
	  Promise.race([ajax('foo.json'), timeout(5000)])
	  ```

	  @method race
	  @static
	  @param {Array} promises array of promises to observe
	  Useful for tooling.
	  @return {Promise} a promise which settles in the same way as the first passed
	  promise to settle.
	*/
	function race(entries) {
	  /*jshint validthis:true */
	  var Constructor = this;

	  if (!isArray(entries)) {
	    return new Constructor(function (_, reject) {
	      return reject(new TypeError('You must pass an array to race.'));
	    });
	  } else {
	    return new Constructor(function (resolve, reject) {
	      var length = entries.length;
	      for (var i = 0; i < length; i++) {
	        Constructor.resolve(entries[i]).then(resolve, reject);
	      }
	    });
	  }
	}

	/**
	  `Promise.reject` returns a promise rejected with the passed `reason`.
	  It is shorthand for the following:

	  ```javascript
	  let promise = new Promise(function(resolve, reject){
	    reject(new Error('WHOOPS'));
	  });

	  promise.then(function(value){
	    // Code here doesn't run because the promise is rejected!
	  }, function(reason){
	    // reason.message === 'WHOOPS'
	  });
	  ```

	  Instead of writing the above, your code now simply becomes the following:

	  ```javascript
	  let promise = Promise.reject(new Error('WHOOPS'));

	  promise.then(function(value){
	    // Code here doesn't run because the promise is rejected!
	  }, function(reason){
	    // reason.message === 'WHOOPS'
	  });
	  ```

	  @method reject
	  @static
	  @param {Any} reason value that the returned promise will be rejected with.
	  Useful for tooling.
	  @return {Promise} a promise rejected with the given `reason`.
	*/
	function reject(reason) {
	  /*jshint validthis:true */
	  var Constructor = this;
	  var promise = new Constructor(noop);
	  _reject(promise, reason);
	  return promise;
	}

	function needsResolver() {
	  throw new TypeError('You must pass a resolver function as the first argument to the promise constructor');
	}

	function needsNew() {
	  throw new TypeError("Failed to construct 'Promise': Please use the 'new' operator, this object constructor cannot be called as a function.");
	}

	/**
	  Promise objects represent the eventual result of an asynchronous operation. The
	  primary way of interacting with a promise is through its `then` method, which
	  registers callbacks to receive either a promise's eventual value or the reason
	  why the promise cannot be fulfilled.

	  Terminology
	  -----------

	  - `promise` is an object or function with a `then` method whose behavior conforms to this specification.
	  - `thenable` is an object or function that defines a `then` method.
	  - `value` is any legal JavaScript value (including undefined, a thenable, or a promise).
	  - `exception` is a value that is thrown using the throw statement.
	  - `reason` is a value that indicates why a promise was rejected.
	  - `settled` the final resting state of a promise, fulfilled or rejected.

	  A promise can be in one of three states: pending, fulfilled, or rejected.

	  Promises that are fulfilled have a fulfillment value and are in the fulfilled
	  state.  Promises that are rejected have a rejection reason and are in the
	  rejected state.  A fulfillment value is never a thenable.

	  Promises can also be said to *resolve* a value.  If this value is also a
	  promise, then the original promise's settled state will match the value's
	  settled state.  So a promise that *resolves* a promise that rejects will
	  itself reject, and a promise that *resolves* a promise that fulfills will
	  itself fulfill.


	  Basic Usage:
	  ------------

	  ```js
	  let promise = new Promise(function(resolve, reject) {
	    // on success
	    resolve(value);

	    // on failure
	    reject(reason);
	  });

	  promise.then(function(value) {
	    // on fulfillment
	  }, function(reason) {
	    // on rejection
	  });
	  ```

	  Advanced Usage:
	  ---------------

	  Promises shine when abstracting away asynchronous interactions such as
	  `XMLHttpRequest`s.

	  ```js
	  function getJSON(url) {
	    return new Promise(function(resolve, reject){
	      let xhr = new XMLHttpRequest();

	      xhr.open('GET', url);
	      xhr.onreadystatechange = handler;
	      xhr.responseType = 'json';
	      xhr.setRequestHeader('Accept', 'application/json');
	      xhr.send();

	      function handler() {
	        if (this.readyState === this.DONE) {
	          if (this.status === 200) {
	            resolve(this.response);
	          } else {
	            reject(new Error('getJSON: `' + url + '` failed with status: [' + this.status + ']'));
	          }
	        }
	      };
	    });
	  }

	  getJSON('/posts.json').then(function(json) {
	    // on fulfillment
	  }, function(reason) {
	    // on rejection
	  });
	  ```

	  Unlike callbacks, promises are great composable primitives.

	  ```js
	  Promise.all([
	    getJSON('/posts'),
	    getJSON('/comments')
	  ]).then(function(values){
	    values[0] // => postsJSON
	    values[1] // => commentsJSON

	    return values;
	  });
	  ```

	  @class Promise
	  @param {function} resolver
	  Useful for tooling.
	  @constructor
	*/
	function Promise(resolver) {
	  this[PROMISE_ID] = nextId();
	  this._result = this._state = undefined;
	  this._subscribers = [];

	  if (noop !== resolver) {
	    typeof resolver !== 'function' && needsResolver();
	    this instanceof Promise ? initializePromise(this, resolver) : needsNew();
	  }
	}

	Promise.all = all;
	Promise.race = race;
	Promise.resolve = resolve;
	Promise.reject = reject;
	Promise._setScheduler = setScheduler;
	Promise._setAsap = setAsap;
	Promise._asap = asap;

	Promise.prototype = {
	  constructor: Promise,

	  /**
	    The primary way of interacting with a promise is through its `then` method,
	    which registers callbacks to receive either a promise's eventual value or the
	    reason why the promise cannot be fulfilled.
	  
	    ```js
	    findUser().then(function(user){
	      // user is available
	    }, function(reason){
	      // user is unavailable, and you are given the reason why
	    });
	    ```
	  
	    Chaining
	    --------
	  
	    The return value of `then` is itself a promise.  This second, 'downstream'
	    promise is resolved with the return value of the first promise's fulfillment
	    or rejection handler, or rejected if the handler throws an exception.
	  
	    ```js
	    findUser().then(function (user) {
	      return user.name;
	    }, function (reason) {
	      return 'default name';
	    }).then(function (userName) {
	      // If `findUser` fulfilled, `userName` will be the user's name, otherwise it
	      // will be `'default name'`
	    });
	  
	    findUser().then(function (user) {
	      throw new Error('Found user, but still unhappy');
	    }, function (reason) {
	      throw new Error('`findUser` rejected and we're unhappy');
	    }).then(function (value) {
	      // never reached
	    }, function (reason) {
	      // if `findUser` fulfilled, `reason` will be 'Found user, but still unhappy'.
	      // If `findUser` rejected, `reason` will be '`findUser` rejected and we're unhappy'.
	    });
	    ```
	    If the downstream promise does not specify a rejection handler, rejection reasons will be propagated further downstream.
	  
	    ```js
	    findUser().then(function (user) {
	      throw new PedagogicalException('Upstream error');
	    }).then(function (value) {
	      // never reached
	    }).then(function (value) {
	      // never reached
	    }, function (reason) {
	      // The `PedgagocialException` is propagated all the way down to here
	    });
	    ```
	  
	    Assimilation
	    ------------
	  
	    Sometimes the value you want to propagate to a downstream promise can only be
	    retrieved asynchronously. This can be achieved by returning a promise in the
	    fulfillment or rejection handler. The downstream promise will then be pending
	    until the returned promise is settled. This is called *assimilation*.
	  
	    ```js
	    findUser().then(function (user) {
	      return findCommentsByAuthor(user);
	    }).then(function (comments) {
	      // The user's comments are now available
	    });
	    ```
	  
	    If the assimliated promise rejects, then the downstream promise will also reject.
	  
	    ```js
	    findUser().then(function (user) {
	      return findCommentsByAuthor(user);
	    }).then(function (comments) {
	      // If `findCommentsByAuthor` fulfills, we'll have the value here
	    }, function (reason) {
	      // If `findCommentsByAuthor` rejects, we'll have the reason here
	    });
	    ```
	  
	    Simple Example
	    --------------
	  
	    Synchronous Example
	  
	    ```javascript
	    let result;
	  
	    try {
	      result = findResult();
	      // success
	    } catch(reason) {
	      // failure
	    }
	    ```
	  
	    Errback Example
	  
	    ```js
	    findResult(function(result, err){
	      if (err) {
	        // failure
	      } else {
	        // success
	      }
	    });
	    ```
	  
	    Promise Example;
	  
	    ```javascript
	    findResult().then(function(result){
	      // success
	    }, function(reason){
	      // failure
	    });
	    ```
	  
	    Advanced Example
	    --------------
	  
	    Synchronous Example
	  
	    ```javascript
	    let author, books;
	  
	    try {
	      author = findAuthor();
	      books  = findBooksByAuthor(author);
	      // success
	    } catch(reason) {
	      // failure
	    }
	    ```
	  
	    Errback Example
	  
	    ```js
	  
	    function foundBooks(books) {
	  
	    }
	  
	    function failure(reason) {
	  
	    }
	  
	    findAuthor(function(author, err){
	      if (err) {
	        failure(err);
	        // failure
	      } else {
	        try {
	          findBoooksByAuthor(author, function(books, err) {
	            if (err) {
	              failure(err);
	            } else {
	              try {
	                foundBooks(books);
	              } catch(reason) {
	                failure(reason);
	              }
	            }
	          });
	        } catch(error) {
	          failure(err);
	        }
	        // success
	      }
	    });
	    ```
	  
	    Promise Example;
	  
	    ```javascript
	    findAuthor().
	      then(findBooksByAuthor).
	      then(function(books){
	        // found books
	    }).catch(function(reason){
	      // something went wrong
	    });
	    ```
	  
	    @method then
	    @param {Function} onFulfilled
	    @param {Function} onRejected
	    Useful for tooling.
	    @return {Promise}
	  */
	  then: then,

	  /**
	    `catch` is simply sugar for `then(undefined, onRejection)` which makes it the same
	    as the catch block of a try/catch statement.
	  
	    ```js
	    function findAuthor(){
	      throw new Error('couldn't find that author');
	    }
	  
	    // synchronous
	    try {
	      findAuthor();
	    } catch(reason) {
	      // something went wrong
	    }
	  
	    // async with promises
	    findAuthor().catch(function(reason){
	      // something went wrong
	    });
	    ```
	  
	    @method catch
	    @param {Function} onRejection
	    Useful for tooling.
	    @return {Promise}
	  */
	  'catch': function _catch(onRejection) {
	    return this.then(null, onRejection);
	  }
	};

	function polyfill() {
	    var local = undefined;

	    if (typeof global !== 'undefined') {
	        local = global;
	    } else if (typeof self !== 'undefined') {
	        local = self;
	    } else {
	        try {
	            local = Function('return this')();
	        } catch (e) {
	            throw new Error('polyfill failed because global object is unavailable in this environment');
	        }
	    }

	    var P = local.Promise;

	    if (P) {
	        var promiseToString = null;
	        try {
	            promiseToString = Object.prototype.toString.call(P.resolve());
	        } catch (e) {
	            // silently ignored
	        }

	        if (promiseToString === '[object Promise]' && !P.cast) {
	            return;
	        }
	    }

	    local.Promise = Promise;
	}

	polyfill();
	// Strange compat..
	Promise.polyfill = polyfill;
	Promise.Promise = Promise;

	return Promise;

	})));
	//# sourceMappingURL=es6-promise.map

	/*** EXPORTS FROM exports-loader ***/
	module.exports = global.Promise;
	}.call(global));
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(15), __webpack_require__(14), (function() { return this; }())))

/***/ },
/* 15 */
/***/ function(module, exports) {

	// shim for using process in browser
	var process = module.exports = {};

	// cached from whatever global is present so that test runners that stub it
	// don't break things.  But we need to wrap it in a try catch in case it is
	// wrapped in strict mode code which doesn't define any globals.  It's inside a
	// function because try/catches deoptimize in certain engines.

	var cachedSetTimeout;
	var cachedClearTimeout;

	function defaultSetTimout() {
	    throw new Error('setTimeout has not been defined');
	}
	function defaultClearTimeout () {
	    throw new Error('clearTimeout has not been defined');
	}
	(function () {
	    try {
	        if (typeof setTimeout === 'function') {
	            cachedSetTimeout = setTimeout;
	        } else {
	            cachedSetTimeout = defaultSetTimout;
	        }
	    } catch (e) {
	        cachedSetTimeout = defaultSetTimout;
	    }
	    try {
	        if (typeof clearTimeout === 'function') {
	            cachedClearTimeout = clearTimeout;
	        } else {
	            cachedClearTimeout = defaultClearTimeout;
	        }
	    } catch (e) {
	        cachedClearTimeout = defaultClearTimeout;
	    }
	} ())
	function runTimeout(fun) {
	    if (cachedSetTimeout === setTimeout) {
	        //normal enviroments in sane situations
	        return setTimeout(fun, 0);
	    }
	    // if setTimeout wasn't available but was latter defined
	    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
	        cachedSetTimeout = setTimeout;
	        return setTimeout(fun, 0);
	    }
	    try {
	        // when when somebody has screwed with setTimeout but no I.E. maddness
	        return cachedSetTimeout(fun, 0);
	    } catch(e){
	        try {
	            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
	            return cachedSetTimeout.call(null, fun, 0);
	        } catch(e){
	            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
	            return cachedSetTimeout.call(this, fun, 0);
	        }
	    }


	}
	function runClearTimeout(marker) {
	    if (cachedClearTimeout === clearTimeout) {
	        //normal enviroments in sane situations
	        return clearTimeout(marker);
	    }
	    // if clearTimeout wasn't available but was latter defined
	    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
	        cachedClearTimeout = clearTimeout;
	        return clearTimeout(marker);
	    }
	    try {
	        // when when somebody has screwed with setTimeout but no I.E. maddness
	        return cachedClearTimeout(marker);
	    } catch (e){
	        try {
	            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
	            return cachedClearTimeout.call(null, marker);
	        } catch (e){
	            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
	            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
	            return cachedClearTimeout.call(this, marker);
	        }
	    }



	}
	var queue = [];
	var draining = false;
	var currentQueue;
	var queueIndex = -1;

	function cleanUpNextTick() {
	    if (!draining || !currentQueue) {
	        return;
	    }
	    draining = false;
	    if (currentQueue.length) {
	        queue = currentQueue.concat(queue);
	    } else {
	        queueIndex = -1;
	    }
	    if (queue.length) {
	        drainQueue();
	    }
	}

	function drainQueue() {
	    if (draining) {
	        return;
	    }
	    var timeout = runTimeout(cleanUpNextTick);
	    draining = true;

	    var len = queue.length;
	    while(len) {
	        currentQueue = queue;
	        queue = [];
	        while (++queueIndex < len) {
	            if (currentQueue) {
	                currentQueue[queueIndex].run();
	            }
	        }
	        queueIndex = -1;
	        len = queue.length;
	    }
	    currentQueue = null;
	    draining = false;
	    runClearTimeout(timeout);
	}

	process.nextTick = function (fun) {
	    var args = new Array(arguments.length - 1);
	    if (arguments.length > 1) {
	        for (var i = 1; i < arguments.length; i++) {
	            args[i - 1] = arguments[i];
	        }
	    }
	    queue.push(new Item(fun, args));
	    if (queue.length === 1 && !draining) {
	        runTimeout(drainQueue);
	    }
	};

	// v8 likes predictible objects
	function Item(fun, array) {
	    this.fun = fun;
	    this.array = array;
	}
	Item.prototype.run = function () {
	    this.fun.apply(null, this.array);
	};
	process.title = 'browser';
	process.browser = true;
	process.env = {};
	process.argv = [];
	process.version = ''; // empty string to avoid regexp issues
	process.versions = {};

	function noop() {}

	process.on = noop;
	process.addListener = noop;
	process.once = noop;
	process.off = noop;
	process.removeListener = noop;
	process.removeAllListeners = noop;
	process.emit = noop;

	process.binding = function (name) {
	    throw new Error('process.binding is not supported');
	};

	process.cwd = function () { return '/' };
	process.chdir = function (dir) {
	    throw new Error('process.chdir is not supported');
	};
	process.umask = function() { return 0; };


/***/ },
/* 16 */
/***/ function(module, exports) {

	/* (ignored) */

/***/ }
/******/ ]);